/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1.user;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class UserConversationDeleter extends Deleter<UserConversation> {
    private final String pathUserSid;
    private final String pathConversationSid;

    /**
     * Construct a new UserConversationDeleter.
     *
     * @param pathUserSid The unique SID identifier of the User.
     * @param pathConversationSid The unique SID identifier of the Conversation.
     */
    public UserConversationDeleter(final String pathUserSid,
                                   final String pathConversationSid) {
        this.pathUserSid = pathUserSid;
        this.pathConversationSid = pathConversationSid;
    }

    /**
     * Make the request to the Twilio API to perform the delete.
     *
     * @param client TwilioRestClient with which to make the request
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public boolean delete(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.DELETE,
            Domains.CONVERSATIONS.toString(),
            "/v1/Users/" + this.pathUserSid + "/Conversations/" + this.pathConversationSid + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("UserConversation delete failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return response.getStatusCode() == 204;
    }
}