/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.events.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;
import java.util.Map;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class SubscriptionCreator extends Creator<Subscription> {
    private final String description;
    private final String sinkSid;
    private final List<Map<String, Object>> types;

    /**
     * Construct a new SubscriptionCreator.
     *
     * @param description Subscription description
     * @param sinkSid Sink SID.
     * @param types Subscribed Event Types
     */
    public SubscriptionCreator(final String description,
                               final String sinkSid,
                               final List<Map<String, Object>> types) {
        this.description = description;
        this.sinkSid = sinkSid;
        this.types = types;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Subscription
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Subscription create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.EVENTS.toString(),
            "/v1/Subscriptions"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Subscription creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Subscription.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (description != null) {
            request.addPostParam("Description", description);
        }

        if (sinkSid != null) {
            request.addPostParam("SinkSid", sinkSid);
        }

        if (types != null) {
            for (Map<String, Object> prop : types) {
                request.addPostParam("Types", Converter.mapToJson(prop));
            }
        }
    }
}