/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.events.v1.subscription;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class SubscribedEventFetcher extends Fetcher<SubscribedEvent> {
    private final String pathSubscriptionSid;
    private final String pathType;

    /**
     * Construct a new SubscribedEventFetcher.
     *
     * @param pathSubscriptionSid Subscription SID.
     * @param pathType Type of event being subscribed to.
     */
    public SubscribedEventFetcher(final String pathSubscriptionSid,
                                  final String pathType) {
        this.pathSubscriptionSid = pathSubscriptionSid;
        this.pathType = pathType;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched SubscribedEvent
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public SubscribedEvent fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.EVENTS.toString(),
            "/v1/Subscriptions/" + this.pathSubscriptionSid + "/SubscribedEvents/" + this.pathType + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("SubscribedEvent fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return SubscribedEvent.fromJson(response.getStream(), client.getObjectMapper());
    }
}