/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class ChannelCreator extends Creator<Channel> {
    private final String flexFlowSid;
    private final String identity;
    private final String chatUserFriendlyName;
    private final String chatFriendlyName;
    private String target;
    private String chatUniqueName;
    private String preEngagementData;
    private String taskSid;
    private String taskAttributes;
    private Boolean longLived;

    /**
     * Construct a new ChannelCreator.
     *
     * @param flexFlowSid The SID of the Flex Flow
     * @param identity The identity value that identifies the new resource's chat
     *                 User
     * @param chatUserFriendlyName The chat participant's friendly name
     * @param chatFriendlyName The chat channel's friendly name
     */
    public ChannelCreator(final String flexFlowSid,
                          final String identity,
                          final String chatUserFriendlyName,
                          final String chatFriendlyName) {
        this.flexFlowSid = flexFlowSid;
        this.identity = identity;
        this.chatUserFriendlyName = chatUserFriendlyName;
        this.chatFriendlyName = chatFriendlyName;
    }

    /**
     * The Target Contact Identity, for example the phone number of an SMS..
     *
     * @param target The Target Contact Identity
     * @return this
     */
    public ChannelCreator setTarget(final String target) {
        this.target = target;
        return this;
    }

    /**
     * The chat channel's unique name..
     *
     * @param chatUniqueName The chat channel's unique name
     * @return this
     */
    public ChannelCreator setChatUniqueName(final String chatUniqueName) {
        this.chatUniqueName = chatUniqueName;
        return this;
    }

    /**
     * The pre-engagement data..
     *
     * @param preEngagementData The pre-engagement data
     * @return this
     */
    public ChannelCreator setPreEngagementData(final String preEngagementData) {
        this.preEngagementData = preEngagementData;
        return this;
    }

    /**
     * The SID of the TaskRouter Task. Only valid when integration type is `task`.
     * `null` for integration types `studio` &amp; `external`.
     *
     * @param taskSid The SID of the TaskRouter Task
     * @return this
     */
    public ChannelCreator setTaskSid(final String taskSid) {
        this.taskSid = taskSid;
        return this;
    }

    /**
     * The Task attributes to be added for the TaskRouter Task..
     *
     * @param taskAttributes The Task attributes to be added for the TaskRouter Task
     * @return this
     */
    public ChannelCreator setTaskAttributes(final String taskAttributes) {
        this.taskAttributes = taskAttributes;
        return this;
    }

    /**
     * Whether to create the channel as long-lived..
     *
     * @param longLived Whether to create the channel as long-lived
     * @return this
     */
    public ChannelCreator setLongLived(final Boolean longLived) {
        this.longLived = longLived;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Channel
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Channel create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.FLEXAPI.toString(),
            "/v1/Channels"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Channel creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (flexFlowSid != null) {
            request.addPostParam("FlexFlowSid", flexFlowSid);
        }

        if (identity != null) {
            request.addPostParam("Identity", identity);
        }

        if (chatUserFriendlyName != null) {
            request.addPostParam("ChatUserFriendlyName", chatUserFriendlyName);
        }

        if (chatFriendlyName != null) {
            request.addPostParam("ChatFriendlyName", chatFriendlyName);
        }

        if (target != null) {
            request.addPostParam("Target", target);
        }

        if (chatUniqueName != null) {
            request.addPostParam("ChatUniqueName", chatUniqueName);
        }

        if (preEngagementData != null) {
            request.addPostParam("PreEngagementData", preEngagementData);
        }

        if (taskSid != null) {
            request.addPostParam("TaskSid", taskSid);
        }

        if (taskAttributes != null) {
            request.addPostParam("TaskAttributes", taskAttributes);
        }

        if (longLived != null) {
            request.addPostParam("LongLived", longLived.toString());
        }
    }
}