/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class ConfigurationFetcher extends Fetcher<Configuration> {
    private String uiVersion;

    /**
     * The Pinned UI version of the Configuration resource to fetch..
     *
     * @param uiVersion The Pinned UI version of the Configuration resource to fetch
     * @return this
     */
    public ConfigurationFetcher setUiVersion(final String uiVersion) {
        this.uiVersion = uiVersion;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched Configuration
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Configuration fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.FLEXAPI.toString(),
            "/v1/Configuration"
        );

        addQueryParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Configuration fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Configuration.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (uiVersion != null) {
            request.addQueryParam("UiVersion", uiVersion);
        }
    }
}