/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Interaction extends Resource {
    private static final long serialVersionUID = 106205438010553L;

    public enum Status {
        CLOSE("close"),
        CLOSED("closed"),
        WRAPUP("wrapup");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    /**
     * Create a InteractionFetcher to execute fetch.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @return InteractionFetcher capable of executing the fetch
     */
    public static InteractionFetcher fetcher(final String pathSid) {
        return new InteractionFetcher(pathSid);
    }

    /**
     * Create a InteractionCreator to execute create.
     *
     * @param channel The Interaction's channel
     * @param routing The Interaction's routing logic
     * @return InteractionCreator capable of executing the create
     */
    public static InteractionCreator creator(final Map<String, Object> channel,
                                             final Map<String, Object> routing) {
        return new InteractionCreator(channel, routing);
    }

    /**
     * Converts a JSON String into a Interaction object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Interaction object represented by the provided JSON
     */
    public static Interaction fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Interaction.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Interaction object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Interaction object represented by the provided JSON
     */
    public static Interaction fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Interaction.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final Map<String, Object> channel;
    private final Map<String, Object> routing;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Interaction(@JsonProperty("sid")
                        final String sid,
                        @JsonProperty("channel")
                        final Map<String, Object> channel,
                        @JsonProperty("routing")
                        final Map<String, Object> routing,
                        @JsonProperty("url")
                        final URI url,
                        @JsonProperty("links")
                        final Map<String, String> links) {
        this.sid = sid;
        this.channel = channel;
        this.routing = routing;
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The Interaction's channel.
     *
     * @return The Interaction's channel
     */
    public final Map<String, Object> getChannel() {
        return this.channel;
    }

    /**
     * Returns The Interaction's routing logic.
     *
     * @return The Interaction's routing logic
     */
    public final Map<String, Object> getRouting() {
        return this.routing;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The links.
     *
     * @return The links
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Interaction other = (Interaction) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(channel, other.channel) &&
               Objects.equals(routing, other.routing) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            channel,
                            routing,
                            url,
                            links);
    }
}