/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1.interaction;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.Map;

public class InteractionChannelUpdater extends Updater<InteractionChannel> {
    private final String pathInteractionSid;
    private final String pathSid;
    private final InteractionChannel.Status status;
    private Map<String, Object> routing;

    /**
     * Construct a new InteractionChannelUpdater.
     *
     * @param pathInteractionSid The Interaction Sid for this channel.
     * @param pathSid The unique string that identifies the resource
     * @param status The Interaction Channels's status
     */
    public InteractionChannelUpdater(final String pathInteractionSid,
                                     final String pathSid,
                                     final InteractionChannel.Status status) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    /**
     * The Interaction Channel's routing parameters.  Optional, may contain `status`
     * to set the agent's Reservation state to either `closed` or `wrapup`.  Default
     * is `wrapup` if unspecified..
     *
     * @param routing The Interaction Channels's optional routing parameters
     * @return this
     */
    public InteractionChannelUpdater setRouting(final Map<String, Object> routing) {
        this.routing = routing;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated InteractionChannel
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public InteractionChannel update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.FLEXAPI.toString(),
            "/v1/Interactions/" + this.pathInteractionSid + "/Channels/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("InteractionChannel update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return InteractionChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (status != null) {
            request.addPostParam("Status", status.toString());
        }

        if (routing != null) {
            request.addPostParam("Routing", Converter.mapToJson(routing));
        }
    }
}