/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class InteractionChannelInvite extends Resource {
    private static final long serialVersionUID = 118671560206148L;

    public enum Action {
        ACCEPT("accept"),
        DECLINE("decline");

        private final String value;

        private Action(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Action from a string.
         * @param value string value
         * @return generated Action
         */
        @JsonCreator
        public static Action forValue(final String value) {
            return Promoter.enumFromString(value, Action.values());
        }
    }

    public enum Type {
        TASKROUTER("taskrouter");

        private final String value;

        private Type(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Type from a string.
         * @param value string value
         * @return generated Type
         */
        @JsonCreator
        public static Type forValue(final String value) {
            return Promoter.enumFromString(value, Type.values());
        }
    }

    /**
     * Create a InteractionChannelInviteCreator to execute create.
     *
     * @param pathInteractionSid The interaction_sid
     * @param pathChannelSid The channel_sid
     * @param routing The routing
     * @return InteractionChannelInviteCreator capable of executing the create
     */
    public static InteractionChannelInviteCreator creator(final String pathInteractionSid,
                                                          final String pathChannelSid,
                                                          final Map<String, Object> routing) {
        return new InteractionChannelInviteCreator(pathInteractionSid, pathChannelSid, routing);
    }

    /**
     * Create a InteractionChannelInviteReader to execute read.
     *
     * @param pathInteractionSid The interaction_sid
     * @param pathChannelSid The channel_sid
     * @return InteractionChannelInviteReader capable of executing the read
     */
    public static InteractionChannelInviteReader reader(final String pathInteractionSid,
                                                        final String pathChannelSid) {
        return new InteractionChannelInviteReader(pathInteractionSid, pathChannelSid);
    }

    /**
     * Converts a JSON String into a InteractionChannelInvite object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return InteractionChannelInvite object represented by the provided JSON
     */
    public static InteractionChannelInvite fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, InteractionChannelInvite.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a InteractionChannelInvite object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return InteractionChannelInvite object represented by the provided JSON
     */
    public static InteractionChannelInvite fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, InteractionChannelInvite.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String interactionSid;
    private final String channelSid;
    private final Map<String, Object> routing;
    private final URI url;

    @JsonCreator
    private InteractionChannelInvite(@JsonProperty("sid")
                                     final String sid,
                                     @JsonProperty("interaction_sid")
                                     final String interactionSid,
                                     @JsonProperty("channel_sid")
                                     final String channelSid,
                                     @JsonProperty("routing")
                                     final Map<String, Object> routing,
                                     @JsonProperty("url")
                                     final URI url) {
        this.sid = sid;
        this.interactionSid = interactionSid;
        this.channelSid = channelSid;
        this.routing = routing;
        this.url = url;
    }

    /**
     * Returns The sid.
     *
     * @return The sid
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The interaction_sid.
     *
     * @return The interaction_sid
     */
    public final String getInteractionSid() {
        return this.interactionSid;
    }

    /**
     * Returns The channel_sid.
     *
     * @return The channel_sid
     */
    public final String getChannelSid() {
        return this.channelSid;
    }

    /**
     * Returns The routing.
     *
     * @return The routing
     */
    public final Map<String, Object> getRouting() {
        return this.routing;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        InteractionChannelInvite other = (InteractionChannelInvite) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(interactionSid, other.interactionSid) &&
               Objects.equals(channelSid, other.channelSid) &&
               Objects.equals(routing, other.routing) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            interactionSid,
                            channelSid,
                            routing,
                            url);
    }
}