/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.frontlineapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class User extends Resource {
    private static final long serialVersionUID = 130602894485195L;

    public enum StateType {
        ACTIVE("active"),
        DEACTIVATED("deactivated");

        private final String value;

        private StateType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a StateType from a string.
         * @param value string value
         * @return generated StateType
         */
        @JsonCreator
        public static StateType forValue(final String value) {
            return Promoter.enumFromString(value, StateType.values());
        }
    }

    /**
     * Create a UserFetcher to execute fetch.
     *
     * @param pathSid The SID of the User resource to fetch
     * @return UserFetcher capable of executing the fetch
     */
    public static UserFetcher fetcher(final String pathSid) {
        return new UserFetcher(pathSid);
    }

    /**
     * Create a UserUpdater to execute update.
     *
     * @param pathSid The SID of the User resource to update
     * @return UserUpdater capable of executing the update
     */
    public static UserUpdater updater(final String pathSid) {
        return new UserUpdater(pathSid);
    }

    /**
     * Converts a JSON String into a User object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return User object represented by the provided JSON
     */
    public static User fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, User.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a User object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return User object represented by the provided JSON
     */
    public static User fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, User.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String identity;
    private final String friendlyName;
    private final String avatar;
    private final User.StateType state;
    private final Boolean isAvailable;
    private final URI url;

    @JsonCreator
    private User(@JsonProperty("sid")
                 final String sid,
                 @JsonProperty("identity")
                 final String identity,
                 @JsonProperty("friendly_name")
                 final String friendlyName,
                 @JsonProperty("avatar")
                 final String avatar,
                 @JsonProperty("state")
                 final User.StateType state,
                 @JsonProperty("is_available")
                 final Boolean isAvailable,
                 @JsonProperty("url")
                 final URI url) {
        this.sid = sid;
        this.identity = identity;
        this.friendlyName = friendlyName;
        this.avatar = avatar;
        this.state = state;
        this.isAvailable = isAvailable;
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The string that identifies the resource's User.
     *
     * @return The string that identifies the resource's User
     */
    public final String getIdentity() {
        return this.identity;
    }

    /**
     * Returns The string that you assigned to describe the User.
     *
     * @return The string that you assigned to describe the User
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The avatar URL which will be shown in Frontline application.
     *
     * @return The avatar URL which will be shown in Frontline application
     */
    public final String getAvatar() {
        return this.avatar;
    }

    /**
     * Returns Current state of this user.
     *
     * @return Current state of this user
     */
    public final User.StateType getState() {
        return this.state;
    }

    /**
     * Returns Whether the User is available for new conversations.
     *
     * @return Whether the User is available for new conversations
     */
    public final Boolean getIsAvailable() {
        return this.isAvailable;
    }

    /**
     * Returns An absolute URL for this user..
     *
     * @return An absolute URL for this user.
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        User other = (User) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(identity, other.identity) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(avatar, other.avatar) &&
               Objects.equals(state, other.state) &&
               Objects.equals(isAvailable, other.isAvailable) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            identity,
                            friendlyName,
                            avatar,
                            state,
                            isAvailable,
                            url);
    }
}