/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.insights.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Annotation extends Resource {
    private static final long serialVersionUID = 274535665430664L;

    public enum AnsweredBy {
        UNKNOWN_ANSWERED_BY("unknown_answered_by"),
        HUMAN("human"),
        MACHINE("machine");

        private final String value;

        private AnsweredBy(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a AnsweredBy from a string.
         * @param value string value
         * @return generated AnsweredBy
         */
        @JsonCreator
        public static AnsweredBy forValue(final String value) {
            return Promoter.enumFromString(value, AnsweredBy.values());
        }
    }

    public enum ConnectivityIssue {
        UNKNOWN_CONNECTIVITY_ISSUE("unknown_connectivity_issue"),
        NO_CONNECTIVITY_ISSUE("no_connectivity_issue"),
        INVALID_NUMBER("invalid_number"),
        CALLER_ID("caller_id"),
        DROPPED_CALL("dropped_call"),
        NUMBER_REACHABILITY("number_reachability");

        private final String value;

        private ConnectivityIssue(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a ConnectivityIssue from a string.
         * @param value string value
         * @return generated ConnectivityIssue
         */
        @JsonCreator
        public static ConnectivityIssue forValue(final String value) {
            return Promoter.enumFromString(value, ConnectivityIssue.values());
        }
    }

    public enum QualityIssues {
        UNKNOWN_QUALITY_ISSUE("unknown_quality_issue"),
        NO_QUALITY_ISSUE("no_quality_issue"),
        LOW_VOLUME("low_volume"),
        CHOPPY_ROBOTIC("choppy_robotic"),
        ECHO("echo"),
        DTMF("dtmf"),
        LATENCY("latency"),
        OWA("owa"),
        STATIC_NOISE("static_noise");

        private final String value;

        private QualityIssues(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a QualityIssues from a string.
         * @param value string value
         * @return generated QualityIssues
         */
        @JsonCreator
        public static QualityIssues forValue(final String value) {
            return Promoter.enumFromString(value, QualityIssues.values());
        }
    }

    /**
     * Create a AnnotationUpdater to execute update.
     *
     * @param pathCallSid The call_sid
     * @return AnnotationUpdater capable of executing the update
     */
    public static AnnotationUpdater updater(final String pathCallSid) {
        return new AnnotationUpdater(pathCallSid);
    }

    /**
     * Create a AnnotationFetcher to execute fetch.
     *
     * @param pathCallSid The call_sid
     * @return AnnotationFetcher capable of executing the fetch
     */
    public static AnnotationFetcher fetcher(final String pathCallSid) {
        return new AnnotationFetcher(pathCallSid);
    }

    /**
     * Converts a JSON String into a Annotation object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Annotation object represented by the provided JSON
     */
    public static Annotation fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Annotation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Annotation object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Annotation object represented by the provided JSON
     */
    public static Annotation fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Annotation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String callSid;
    private final String accountSid;
    private final Annotation.AnsweredBy answeredBy;
    private final Annotation.ConnectivityIssue connectivityIssue;
    private final List<String> qualityIssues;
    private final Boolean spam;
    private final Integer callScore;
    private final String comment;
    private final String incident;
    private final URI url;

    @JsonCreator
    private Annotation(@JsonProperty("call_sid")
                       final String callSid,
                       @JsonProperty("account_sid")
                       final String accountSid,
                       @JsonProperty("answered_by")
                       final Annotation.AnsweredBy answeredBy,
                       @JsonProperty("connectivity_issue")
                       final Annotation.ConnectivityIssue connectivityIssue,
                       @JsonProperty("quality_issues")
                       final List<String> qualityIssues,
                       @JsonProperty("spam")
                       final Boolean spam,
                       @JsonProperty("call_score")
                       final Integer callScore,
                       @JsonProperty("comment")
                       final String comment,
                       @JsonProperty("incident")
                       final String incident,
                       @JsonProperty("url")
                       final URI url) {
        this.callSid = callSid;
        this.accountSid = accountSid;
        this.answeredBy = answeredBy;
        this.connectivityIssue = connectivityIssue;
        this.qualityIssues = qualityIssues;
        this.spam = spam;
        this.callScore = callScore;
        this.comment = comment;
        this.incident = incident;
        this.url = url;
    }

    /**
     * Returns The call_sid.
     *
     * @return The call_sid
     */
    public final String getCallSid() {
        return this.callSid;
    }

    /**
     * Returns The account_sid.
     *
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The answered_by.
     *
     * @return The answered_by
     */
    public final Annotation.AnsweredBy getAnsweredBy() {
        return this.answeredBy;
    }

    /**
     * Returns The connectivity_issue.
     *
     * @return The connectivity_issue
     */
    public final Annotation.ConnectivityIssue getConnectivityIssue() {
        return this.connectivityIssue;
    }

    /**
     * Returns The quality_issues.
     *
     * @return The quality_issues
     */
    public final List<String> getQualityIssues() {
        return this.qualityIssues;
    }

    /**
     * Returns The spam.
     *
     * @return The spam
     */
    public final Boolean getSpam() {
        return this.spam;
    }

    /**
     * Returns The call_score.
     *
     * @return The call_score
     */
    public final Integer getCallScore() {
        return this.callScore;
    }

    /**
     * Returns The comment.
     *
     * @return The comment
     */
    public final String getComment() {
        return this.comment;
    }

    /**
     * Returns The incident.
     *
     * @return The incident
     */
    public final String getIncident() {
        return this.incident;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Annotation other = (Annotation) o;

        return Objects.equals(callSid, other.callSid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(answeredBy, other.answeredBy) &&
               Objects.equals(connectivityIssue, other.connectivityIssue) &&
               Objects.equals(qualityIssues, other.qualityIssues) &&
               Objects.equals(spam, other.spam) &&
               Objects.equals(callScore, other.callScore) &&
               Objects.equals(comment, other.comment) &&
               Objects.equals(incident, other.incident) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(callSid,
                            accountSid,
                            answeredBy,
                            connectivityIssue,
                            qualityIssues,
                            spam,
                            callScore,
                            comment,
                            incident,
                            url);
    }
}