/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.insights.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class AnnotationFetcher extends Fetcher<Annotation> {
    private final String pathCallSid;

    /**
     * Construct a new AnnotationFetcher.
     *
     * @param pathCallSid The call_sid
     */
    public AnnotationFetcher(final String pathCallSid) {
        this.pathCallSid = pathCallSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched Annotation
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Annotation fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.INSIGHTS.toString(),
            "/v1/Voice/" + this.pathCallSid + "/Annotation"
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Annotation fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Annotation.fromJson(response.getStream(), client.getObjectMapper());
    }
}