/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.insights.v1.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Metric extends Resource {
    private static final long serialVersionUID = 44318563826272L;

    public enum TwilioEdge {
        UNKNOWN_EDGE("unknown_edge"),
        CARRIER_EDGE("carrier_edge"),
        SIP_EDGE("sip_edge"),
        SDK_EDGE("sdk_edge"),
        CLIENT_EDGE("client_edge");

        private final String value;

        private TwilioEdge(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a TwilioEdge from a string.
         * @param value string value
         * @return generated TwilioEdge
         */
        @JsonCreator
        public static TwilioEdge forValue(final String value) {
            return Promoter.enumFromString(value, TwilioEdge.values());
        }
    }

    public enum StreamDirection {
        UNKNOWN("unknown"),
        INBOUND("inbound"),
        OUTBOUND("outbound"),
        BOTH("both");

        private final String value;

        private StreamDirection(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a StreamDirection from a string.
         * @param value string value
         * @return generated StreamDirection
         */
        @JsonCreator
        public static StreamDirection forValue(final String value) {
            return Promoter.enumFromString(value, StreamDirection.values());
        }
    }

    /**
     * Create a MetricReader to execute read.
     *
     * @param pathCallSid The call_sid
     * @return MetricReader capable of executing the read
     */
    public static MetricReader reader(final String pathCallSid) {
        return new MetricReader(pathCallSid);
    }

    /**
     * Converts a JSON String into a Metric object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Metric object represented by the provided JSON
     */
    public static Metric fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Metric.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Metric object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Metric object represented by the provided JSON
     */
    public static Metric fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Metric.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String timestamp;
    private final String callSid;
    private final String accountSid;
    private final Metric.TwilioEdge edge;
    private final Metric.StreamDirection direction;
    private final Map<String, Object> carrierEdge;
    private final Map<String, Object> sipEdge;
    private final Map<String, Object> sdkEdge;
    private final Map<String, Object> clientEdge;

    @JsonCreator
    private Metric(@JsonProperty("timestamp")
                   final String timestamp,
                   @JsonProperty("call_sid")
                   final String callSid,
                   @JsonProperty("account_sid")
                   final String accountSid,
                   @JsonProperty("edge")
                   final Metric.TwilioEdge edge,
                   @JsonProperty("direction")
                   final Metric.StreamDirection direction,
                   @JsonProperty("carrier_edge")
                   final Map<String, Object> carrierEdge,
                   @JsonProperty("sip_edge")
                   final Map<String, Object> sipEdge,
                   @JsonProperty("sdk_edge")
                   final Map<String, Object> sdkEdge,
                   @JsonProperty("client_edge")
                   final Map<String, Object> clientEdge) {
        this.timestamp = timestamp;
        this.callSid = callSid;
        this.accountSid = accountSid;
        this.edge = edge;
        this.direction = direction;
        this.carrierEdge = carrierEdge;
        this.sipEdge = sipEdge;
        this.sdkEdge = sdkEdge;
        this.clientEdge = clientEdge;
    }

    /**
     * Returns The timestamp.
     *
     * @return The timestamp
     */
    public final String getTimestamp() {
        return this.timestamp;
    }

    /**
     * Returns The call_sid.
     *
     * @return The call_sid
     */
    public final String getCallSid() {
        return this.callSid;
    }

    /**
     * Returns The account_sid.
     *
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The edge.
     *
     * @return The edge
     */
    public final Metric.TwilioEdge getEdge() {
        return this.edge;
    }

    /**
     * Returns The direction.
     *
     * @return The direction
     */
    public final Metric.StreamDirection getDirection() {
        return this.direction;
    }

    /**
     * Returns The carrier_edge.
     *
     * @return The carrier_edge
     */
    public final Map<String, Object> getCarrierEdge() {
        return this.carrierEdge;
    }

    /**
     * Returns The sip_edge.
     *
     * @return The sip_edge
     */
    public final Map<String, Object> getSipEdge() {
        return this.sipEdge;
    }

    /**
     * Returns The sdk_edge.
     *
     * @return The sdk_edge
     */
    public final Map<String, Object> getSdkEdge() {
        return this.sdkEdge;
    }

    /**
     * Returns The client_edge.
     *
     * @return The client_edge
     */
    public final Map<String, Object> getClientEdge() {
        return this.clientEdge;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Metric other = (Metric) o;

        return Objects.equals(timestamp, other.timestamp) &&
               Objects.equals(callSid, other.callSid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(edge, other.edge) &&
               Objects.equals(direction, other.direction) &&
               Objects.equals(carrierEdge, other.carrierEdge) &&
               Objects.equals(sipEdge, other.sipEdge) &&
               Objects.equals(sdkEdge, other.sdkEdge) &&
               Objects.equals(clientEdge, other.clientEdge);
    }

    @Override
    public int hashCode() {
        return Objects.hash(timestamp,
                            callSid,
                            accountSid,
                            edge,
                            direction,
                            carrierEdge,
                            sipEdge,
                            sdkEdge,
                            clientEdge);
    }
}