/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.media.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class PlayerStreamerCreator extends Creator<PlayerStreamer> {
    private Boolean video;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private Integer maxDuration;

    /**
     * Specifies whether the PlayerStreamer is configured to stream video. Defaults
     * to `true`..
     *
     * @param video Whether the PlayerStreamer is configured to stream video
     * @return this
     */
    public PlayerStreamerCreator setVideo(final Boolean video) {
        this.video = video;
        return this;
    }

    /**
     * The URL to which Twilio will send asynchronous webhook requests for every
     * PlayerStreamer event. See <a href="/docs/live/status-callbacks">Status
     * Callbacks</a> for more details..
     *
     * @param statusCallback The URL to which Twilio will send PlayerStreamer event
     *                       updates
     * @return this
     */
    public PlayerStreamerCreator setStatusCallback(final URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    /**
     * The URL to which Twilio will send asynchronous webhook requests for every
     * PlayerStreamer event. See <a href="/docs/live/status-callbacks">Status
     * Callbacks</a> for more details..
     *
     * @param statusCallback The URL to which Twilio will send PlayerStreamer event
     *                       updates
     * @return this
     */
    public PlayerStreamerCreator setStatusCallback(final String statusCallback) {
        return setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    /**
     * The HTTP method Twilio should use to call the `status_callback` URL. Can be
     * `POST` or `GET` and the default is `POST`..
     *
     * @param statusCallbackMethod The HTTP method Twilio should use to call the
     *                             `status_callback` URL
     * @return this
     */
    public PlayerStreamerCreator setStatusCallbackMethod(final HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    /**
     * The maximum time, in seconds, that the PlayerStreamer can run before
     * automatically ends. The default value is 300 seconds, and the maximum value
     * is 90000 seconds. Once this maximum duration is reached, Twilio will end the
     * PlayerStreamer, regardless of whether media is still streaming..
     *
     * @param maxDuration Maximum PlayerStreamer duration in seconds
     * @return this
     */
    public PlayerStreamerCreator setMaxDuration(final Integer maxDuration) {
        this.maxDuration = maxDuration;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created PlayerStreamer
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public PlayerStreamer create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.MEDIA.toString(),
            "/v1/PlayerStreamers"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("PlayerStreamer creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return PlayerStreamer.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (video != null) {
            request.addPostParam("Video", video.toString());
        }

        if (statusCallback != null) {
            request.addPostParam("StatusCallback", statusCallback.toString());
        }

        if (statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", statusCallbackMethod.toString());
        }

        if (maxDuration != null) {
            request.addPostParam("MaxDuration", maxDuration.toString());
        }
    }
}