/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.messaging.v1.brandregistration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class BrandVetting extends Resource {
    private static final long serialVersionUID = 266302843566120L;

    public enum VettingProvider {
        CAMPAIGN_VERIFY("campaign-verify");

        private final String value;

        private VettingProvider(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a VettingProvider from a string.
         * @param value string value
         * @return generated VettingProvider
         */
        @JsonCreator
        public static VettingProvider forValue(final String value) {
            return Promoter.enumFromString(value, VettingProvider.values());
        }
    }

    /**
     * Create a BrandVettingCreator to execute create.
     *
     * @param pathBrandSid A2P BrandRegistration Sid
     * @param vettingProvider Third-party provider of the vettings to create
     * @return BrandVettingCreator capable of executing the create
     */
    public static BrandVettingCreator creator(final String pathBrandSid,
                                              final BrandVetting.VettingProvider vettingProvider) {
        return new BrandVettingCreator(pathBrandSid, vettingProvider);
    }

    /**
     * Create a BrandVettingReader to execute read.
     *
     * @param pathBrandSid A2P BrandRegistration Sid
     * @return BrandVettingReader capable of executing the read
     */
    public static BrandVettingReader reader(final String pathBrandSid) {
        return new BrandVettingReader(pathBrandSid);
    }

    /**
     * Create a BrandVettingFetcher to execute fetch.
     *
     * @param pathBrandSid A2P BrandRegistration Sid
     * @param pathBrandVettingSid SID for third-party vetting record
     * @return BrandVettingFetcher capable of executing the fetch
     */
    public static BrandVettingFetcher fetcher(final String pathBrandSid,
                                              final String pathBrandVettingSid) {
        return new BrandVettingFetcher(pathBrandSid, pathBrandVettingSid);
    }

    /**
     * Converts a JSON String into a BrandVetting object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return BrandVetting object represented by the provided JSON
     */
    public static BrandVetting fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BrandVetting.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a BrandVetting object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return BrandVetting object represented by the provided JSON
     */
    public static BrandVetting fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BrandVetting.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String brandSid;
    private final String brandVettingSid;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime dateCreated;
    private final String vettingId;
    private final String vettingClass;
    private final String vettingStatus;
    private final BrandVetting.VettingProvider vettingProvider;
    private final URI url;

    @JsonCreator
    private BrandVetting(@JsonProperty("account_sid")
                         final String accountSid,
                         @JsonProperty("brand_sid")
                         final String brandSid,
                         @JsonProperty("brand_vetting_sid")
                         final String brandVettingSid,
                         @JsonProperty("date_updated")
                         final String dateUpdated,
                         @JsonProperty("date_created")
                         final String dateCreated,
                         @JsonProperty("vetting_id")
                         final String vettingId,
                         @JsonProperty("vetting_class")
                         final String vettingClass,
                         @JsonProperty("vetting_status")
                         final String vettingStatus,
                         @JsonProperty("vetting_provider")
                         final BrandVetting.VettingProvider vettingProvider,
                         @JsonProperty("url")
                         final URI url) {
        this.accountSid = accountSid;
        this.brandSid = brandSid;
        this.brandVettingSid = brandVettingSid;
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.vettingId = vettingId;
        this.vettingClass = vettingClass;
        this.vettingStatus = vettingStatus;
        this.vettingProvider = vettingProvider;
        this.url = url;
    }

    /**
     * Returns The SID of the Account that created the vetting.
     *
     * @return The SID of the Account that created the vetting
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns A2P BrandRegistration Sid.
     *
     * @return A2P BrandRegistration Sid
     */
    public final String getBrandSid() {
        return this.brandSid;
    }

    /**
     * Returns SID for third-party vetting record.
     *
     * @return SID for third-party vetting record
     */
    public final String getBrandVettingSid() {
        return this.brandVettingSid;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The unique ID of the vetting.
     *
     * @return The unique ID of the vetting
     */
    public final String getVettingId() {
        return this.vettingId;
    }

    /**
     * Returns The type of vetting.
     *
     * @return The type of vetting
     */
    public final String getVettingClass() {
        return this.vettingClass;
    }

    /**
     * Returns Status of vetting attempt.
     *
     * @return Status of vetting attempt
     */
    public final String getVettingStatus() {
        return this.vettingStatus;
    }

    /**
     * Returns Third-party provider that has conducted the vetting.
     *
     * @return Third-party provider that has conducted the vetting
     */
    public final BrandVetting.VettingProvider getVettingProvider() {
        return this.vettingProvider;
    }

    /**
     * Returns The absolute URL of the Brand Vetting.
     *
     * @return The absolute URL of the Brand Vetting
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        BrandVetting other = (BrandVetting) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(brandSid, other.brandSid) &&
               Objects.equals(brandVettingSid, other.brandVettingSid) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(vettingId, other.vettingId) &&
               Objects.equals(vettingClass, other.vettingClass) &&
               Objects.equals(vettingStatus, other.vettingStatus) &&
               Objects.equals(vettingProvider, other.vettingProvider) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            brandSid,
                            brandVettingSid,
                            dateUpdated,
                            dateCreated,
                            vettingId,
                            vettingClass,
                            vettingStatus,
                            vettingProvider,
                            url);
    }
}