/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class UsAppToPersonCreator extends Creator<UsAppToPerson> {
    private final String pathMessagingServiceSid;
    private final String brandRegistrationSid;
    private final String description;
    private final List<String> messageSamples;
    private final String usAppToPersonUsecase;
    private final Boolean hasEmbeddedLinks;
    private final Boolean hasEmbeddedPhone;

    /**
     * Construct a new UsAppToPersonCreator.
     *
     * @param pathMessagingServiceSid The SID of the Messaging Service to create
     *                                the resource from
     * @param brandRegistrationSid A2P Brand Registration SID
     * @param description A short description of what this SMS campaign does
     * @param messageSamples Message samples
     * @param usAppToPersonUsecase A2P Campaign Use Case.
     * @param hasEmbeddedLinks Indicates that this SMS campaign will send messages
     *                         that contain links
     * @param hasEmbeddedPhone Indicates that this SMS campaign will send messages
     *                         that contain phone numbers
     */
    public UsAppToPersonCreator(final String pathMessagingServiceSid,
                                final String brandRegistrationSid,
                                final String description,
                                final List<String> messageSamples,
                                final String usAppToPersonUsecase,
                                final Boolean hasEmbeddedLinks,
                                final Boolean hasEmbeddedPhone) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
        this.brandRegistrationSid = brandRegistrationSid;
        this.description = description;
        this.messageSamples = messageSamples;
        this.usAppToPersonUsecase = usAppToPersonUsecase;
        this.hasEmbeddedLinks = hasEmbeddedLinks;
        this.hasEmbeddedPhone = hasEmbeddedPhone;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created UsAppToPerson
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public UsAppToPerson create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.MESSAGING.toString(),
            "/v1/Services/" + this.pathMessagingServiceSid + "/Compliance/Usa2p"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("UsAppToPerson creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return UsAppToPerson.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (brandRegistrationSid != null) {
            request.addPostParam("BrandRegistrationSid", brandRegistrationSid);
        }

        if (description != null) {
            request.addPostParam("Description", description);
        }

        if (messageSamples != null) {
            for (String prop : messageSamples) {
                request.addPostParam("MessageSamples", prop);
            }
        }

        if (usAppToPersonUsecase != null) {
            request.addPostParam("UsAppToPersonUsecase", usAppToPersonUsecase);
        }

        if (hasEmbeddedLinks != null) {
            request.addPostParam("HasEmbeddedLinks", hasEmbeddedLinks.toString());
        }

        if (hasEmbeddedPhone != null) {
            request.addPostParam("HasEmbeddedPhone", hasEmbeddedPhone.toString());
        }
    }
}