/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class UsAppToPersonUsecaseFetcher extends Fetcher<UsAppToPersonUsecase> {
    private final String pathMessagingServiceSid;
    private String brandRegistrationSid;

    /**
     * Construct a new UsAppToPersonUsecaseFetcher.
     *
     * @param pathMessagingServiceSid The SID of the Messaging Service to fetch the
     *                                resource from
     */
    public UsAppToPersonUsecaseFetcher(final String pathMessagingServiceSid) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
    }

    /**
     * The unique string to identify the A2P brand..
     *
     * @param brandRegistrationSid A2P Brand Registration SID
     * @return this
     */
    public UsAppToPersonUsecaseFetcher setBrandRegistrationSid(final String brandRegistrationSid) {
        this.brandRegistrationSid = brandRegistrationSid;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched UsAppToPersonUsecase
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public UsAppToPersonUsecase fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.MESSAGING.toString(),
            "/v1/Services/" + this.pathMessagingServiceSid + "/Compliance/Usa2p/Usecases"
        );

        addQueryParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("UsAppToPersonUsecase fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return UsAppToPersonUsecase.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (brandRegistrationSid != null) {
            request.addQueryParam("BrandRegistrationSid", brandRegistrationSid);
        }
    }
}