/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.notify.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Service extends Resource {
    private static final long serialVersionUID = 267258306183645L;

    /**
     * Create a ServiceCreator to execute create.
     *
     * @return ServiceCreator capable of executing the create
     */
    public static ServiceCreator creator() {
        return new ServiceCreator();
    }

    /**
     * Create a ServiceDeleter to execute delete.
     *
     * @param pathSid The unique string that identifies the resource
     * @return ServiceDeleter capable of executing the delete
     */
    public static ServiceDeleter deleter(final String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    /**
     * Create a ServiceFetcher to execute fetch.
     *
     * @param pathSid The unique string that identifies the resource
     * @return ServiceFetcher capable of executing the fetch
     */
    public static ServiceFetcher fetcher(final String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    /**
     * Create a ServiceReader to execute read.
     *
     * @return ServiceReader capable of executing the read
     */
    public static ServiceReader reader() {
        return new ServiceReader();
    }

    /**
     * Create a ServiceUpdater to execute update.
     *
     * @param pathSid The unique string that identifies the resource
     * @return ServiceUpdater capable of executing the update
     */
    public static ServiceUpdater updater(final String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    /**
     * Converts a JSON String into a Service object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Service object represented by the provided JSON
     */
    public static Service fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Service.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Service object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Service object represented by the provided JSON
     */
    public static Service fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Service.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String apnCredentialSid;
    private final String gcmCredentialSid;
    private final String fcmCredentialSid;
    private final String messagingServiceSid;
    private final String facebookMessengerPageId;
    private final String defaultApnNotificationProtocolVersion;
    private final String defaultGcmNotificationProtocolVersion;
    private final String defaultFcmNotificationProtocolVersion;
    private final Boolean logEnabled;
    private final URI url;
    private final Map<String, String> links;
    private final String alexaSkillId;
    private final String defaultAlexaNotificationProtocolVersion;
    private final String deliveryCallbackUrl;
    private final Boolean deliveryCallbackEnabled;

    @JsonCreator
    private Service(@JsonProperty("sid")
                    final String sid,
                    @JsonProperty("account_sid")
                    final String accountSid,
                    @JsonProperty("friendly_name")
                    final String friendlyName,
                    @JsonProperty("date_created")
                    final String dateCreated,
                    @JsonProperty("date_updated")
                    final String dateUpdated,
                    @JsonProperty("apn_credential_sid")
                    final String apnCredentialSid,
                    @JsonProperty("gcm_credential_sid")
                    final String gcmCredentialSid,
                    @JsonProperty("fcm_credential_sid")
                    final String fcmCredentialSid,
                    @JsonProperty("messaging_service_sid")
                    final String messagingServiceSid,
                    @JsonProperty("facebook_messenger_page_id")
                    final String facebookMessengerPageId,
                    @JsonProperty("default_apn_notification_protocol_version")
                    final String defaultApnNotificationProtocolVersion,
                    @JsonProperty("default_gcm_notification_protocol_version")
                    final String defaultGcmNotificationProtocolVersion,
                    @JsonProperty("default_fcm_notification_protocol_version")
                    final String defaultFcmNotificationProtocolVersion,
                    @JsonProperty("log_enabled")
                    final Boolean logEnabled,
                    @JsonProperty("url")
                    final URI url,
                    @JsonProperty("links")
                    final Map<String, String> links,
                    @JsonProperty("alexa_skill_id")
                    final String alexaSkillId,
                    @JsonProperty("default_alexa_notification_protocol_version")
                    final String defaultAlexaNotificationProtocolVersion,
                    @JsonProperty("delivery_callback_url")
                    final String deliveryCallbackUrl,
                    @JsonProperty("delivery_callback_enabled")
                    final Boolean deliveryCallbackEnabled) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.apnCredentialSid = apnCredentialSid;
        this.gcmCredentialSid = gcmCredentialSid;
        this.fcmCredentialSid = fcmCredentialSid;
        this.messagingServiceSid = messagingServiceSid;
        this.facebookMessengerPageId = facebookMessengerPageId;
        this.defaultApnNotificationProtocolVersion = defaultApnNotificationProtocolVersion;
        this.defaultGcmNotificationProtocolVersion = defaultGcmNotificationProtocolVersion;
        this.defaultFcmNotificationProtocolVersion = defaultFcmNotificationProtocolVersion;
        this.logEnabled = logEnabled;
        this.url = url;
        this.links = links;
        this.alexaSkillId = alexaSkillId;
        this.defaultAlexaNotificationProtocolVersion = defaultAlexaNotificationProtocolVersion;
        this.deliveryCallbackUrl = deliveryCallbackUrl;
        this.deliveryCallbackEnabled = deliveryCallbackEnabled;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The string that you assigned to describe the resource.
     *
     * @return The string that you assigned to describe the resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The RFC 2822 date and time in GMT when the resource was created.
     *
     * @return The RFC 2822 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The RFC 2822 date and time in GMT when the resource was last updated.
     *
     * @return The RFC 2822 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The SID of the Credential to use for APN Bindings.
     *
     * @return The SID of the Credential to use for APN Bindings
     */
    public final String getApnCredentialSid() {
        return this.apnCredentialSid;
    }

    /**
     * Returns The SID of the Credential to use for GCM Bindings.
     *
     * @return The SID of the Credential to use for GCM Bindings
     */
    public final String getGcmCredentialSid() {
        return this.gcmCredentialSid;
    }

    /**
     * Returns The SID of the Credential to use for FCM Bindings.
     *
     * @return The SID of the Credential to use for FCM Bindings
     */
    public final String getFcmCredentialSid() {
        return this.fcmCredentialSid;
    }

    /**
     * Returns The SID of the Messaging Service to use for SMS Bindings.
     *
     * @return The SID of the Messaging Service to use for SMS Bindings
     */
    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    /**
     * Returns Deprecated.
     *
     * @return Deprecated
     */
    public final String getFacebookMessengerPageId() {
        return this.facebookMessengerPageId;
    }

    /**
     * Returns The protocol version to use for sending APNS notifications.
     *
     * @return The protocol version to use for sending APNS notifications
     */
    public final String getDefaultApnNotificationProtocolVersion() {
        return this.defaultApnNotificationProtocolVersion;
    }

    /**
     * Returns The protocol version to use for sending GCM notifications.
     *
     * @return The protocol version to use for sending GCM notifications
     */
    public final String getDefaultGcmNotificationProtocolVersion() {
        return this.defaultGcmNotificationProtocolVersion;
    }

    /**
     * Returns The protocol version to use for sending FCM notifications.
     *
     * @return The protocol version to use for sending FCM notifications
     */
    public final String getDefaultFcmNotificationProtocolVersion() {
        return this.defaultFcmNotificationProtocolVersion;
    }

    /**
     * Returns Whether to log notifications.
     *
     * @return Whether to log notifications
     */
    public final Boolean getLogEnabled() {
        return this.logEnabled;
    }

    /**
     * Returns The absolute URL of the Service resource.
     *
     * @return The absolute URL of the Service resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The URLs of the resources related to the service.
     *
     * @return The URLs of the resources related to the service
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    /**
     * Returns Deprecated.
     *
     * @return Deprecated
     */
    public final String getAlexaSkillId() {
        return this.alexaSkillId;
    }

    /**
     * Returns Deprecated.
     *
     * @return Deprecated
     */
    public final String getDefaultAlexaNotificationProtocolVersion() {
        return this.defaultAlexaNotificationProtocolVersion;
    }

    /**
     * Returns Webhook URL.
     *
     * @return Webhook URL
     */
    public final String getDeliveryCallbackUrl() {
        return this.deliveryCallbackUrl;
    }

    /**
     * Returns Enable delivery callbacks.
     *
     * @return Enable delivery callbacks
     */
    public final Boolean getDeliveryCallbackEnabled() {
        return this.deliveryCallbackEnabled;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Service other = (Service) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(apnCredentialSid, other.apnCredentialSid) &&
               Objects.equals(gcmCredentialSid, other.gcmCredentialSid) &&
               Objects.equals(fcmCredentialSid, other.fcmCredentialSid) &&
               Objects.equals(messagingServiceSid, other.messagingServiceSid) &&
               Objects.equals(facebookMessengerPageId, other.facebookMessengerPageId) &&
               Objects.equals(defaultApnNotificationProtocolVersion, other.defaultApnNotificationProtocolVersion) &&
               Objects.equals(defaultGcmNotificationProtocolVersion, other.defaultGcmNotificationProtocolVersion) &&
               Objects.equals(defaultFcmNotificationProtocolVersion, other.defaultFcmNotificationProtocolVersion) &&
               Objects.equals(logEnabled, other.logEnabled) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links) &&
               Objects.equals(alexaSkillId, other.alexaSkillId) &&
               Objects.equals(defaultAlexaNotificationProtocolVersion, other.defaultAlexaNotificationProtocolVersion) &&
               Objects.equals(deliveryCallbackUrl, other.deliveryCallbackUrl) &&
               Objects.equals(deliveryCallbackEnabled, other.deliveryCallbackEnabled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            friendlyName,
                            dateCreated,
                            dateUpdated,
                            apnCredentialSid,
                            gcmCredentialSid,
                            fcmCredentialSid,
                            messagingServiceSid,
                            facebookMessengerPageId,
                            defaultApnNotificationProtocolVersion,
                            defaultGcmNotificationProtocolVersion,
                            defaultFcmNotificationProtocolVersion,
                            logEnabled,
                            url,
                            links,
                            alexaSkillId,
                            defaultAlexaNotificationProtocolVersion,
                            deliveryCallbackUrl,
                            deliveryCallbackEnabled);
    }
}