/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.deployedDevices.fleet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Certificate extends Resource {
    private static final long serialVersionUID = 78866906209311L;

    /**
     * Create a CertificateFetcher to execute fetch.
     *
     * @param pathFleetSid The fleet_sid
     * @param pathSid A string that uniquely identifies the Certificate.
     * @return CertificateFetcher capable of executing the fetch
     */
    public static CertificateFetcher fetcher(final String pathFleetSid,
                                             final String pathSid) {
        return new CertificateFetcher(pathFleetSid, pathSid);
    }

    /**
     * Create a CertificateDeleter to execute delete.
     *
     * @param pathFleetSid The fleet_sid
     * @param pathSid A string that uniquely identifies the Certificate.
     * @return CertificateDeleter capable of executing the delete
     */
    public static CertificateDeleter deleter(final String pathFleetSid,
                                             final String pathSid) {
        return new CertificateDeleter(pathFleetSid, pathSid);
    }

    /**
     * Create a CertificateCreator to execute create.
     *
     * @param pathFleetSid The fleet_sid
     * @param certificateData The public certificate data.
     * @return CertificateCreator capable of executing the create
     */
    public static CertificateCreator creator(final String pathFleetSid,
                                             final String certificateData) {
        return new CertificateCreator(pathFleetSid, certificateData);
    }

    /**
     * Create a CertificateReader to execute read.
     *
     * @param pathFleetSid The fleet_sid
     * @return CertificateReader capable of executing the read
     */
    public static CertificateReader reader(final String pathFleetSid) {
        return new CertificateReader(pathFleetSid);
    }

    /**
     * Create a CertificateUpdater to execute update.
     *
     * @param pathFleetSid The fleet_sid
     * @param pathSid A string that uniquely identifies the Certificate.
     * @return CertificateUpdater capable of executing the update
     */
    public static CertificateUpdater updater(final String pathFleetSid,
                                             final String pathSid) {
        return new CertificateUpdater(pathFleetSid, pathSid);
    }

    /**
     * Converts a JSON String into a Certificate object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Certificate object represented by the provided JSON
     */
    public static Certificate fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Certificate.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Certificate object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Certificate object represented by the provided JSON
     */
    public static Certificate fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Certificate.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final URI url;
    private final String friendlyName;
    private final String fleetSid;
    private final String accountSid;
    private final String deviceSid;
    private final String thumbprint;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    @JsonCreator
    private Certificate(@JsonProperty("sid")
                        final String sid,
                        @JsonProperty("url")
                        final URI url,
                        @JsonProperty("friendly_name")
                        final String friendlyName,
                        @JsonProperty("fleet_sid")
                        final String fleetSid,
                        @JsonProperty("account_sid")
                        final String accountSid,
                        @JsonProperty("device_sid")
                        final String deviceSid,
                        @JsonProperty("thumbprint")
                        final String thumbprint,
                        @JsonProperty("date_created")
                        final String dateCreated,
                        @JsonProperty("date_updated")
                        final String dateUpdated) {
        this.sid = sid;
        this.url = url;
        this.friendlyName = friendlyName;
        this.fleetSid = fleetSid;
        this.accountSid = accountSid;
        this.deviceSid = deviceSid;
        this.thumbprint = thumbprint;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    /**
     * Returns A string that uniquely identifies this Certificate..
     *
     * @return A string that uniquely identifies this Certificate.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns URL of this Certificate..
     *
     * @return URL of this Certificate.
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns A human readable description for this Certificate..
     *
     * @return A human readable description for this Certificate.
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The unique identifier of the Fleet..
     *
     * @return The unique identifier of the Fleet.
     */
    public final String getFleetSid() {
        return this.fleetSid;
    }

    /**
     * Returns The unique SID that identifies this Account..
     *
     * @return The unique SID that identifies this Account.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The unique identifier of a mapped Device..
     *
     * @return The unique identifier of a mapped Device.
     */
    public final String getDeviceSid() {
        return this.deviceSid;
    }

    /**
     * Returns A Certificate unique payload hash..
     *
     * @return A Certificate unique payload hash.
     */
    public final String getThumbprint() {
        return this.thumbprint;
    }

    /**
     * Returns The date this Certificate was created..
     *
     * @return The date this Certificate was created.
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The date this Certificate was updated..
     *
     * @return The date this Certificate was updated.
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Certificate other = (Certificate) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(url, other.url) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(fleetSid, other.fleetSid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(deviceSid, other.deviceSid) &&
               Objects.equals(thumbprint, other.thumbprint) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            url,
                            friendlyName,
                            fleetSid,
                            accountSid,
                            deviceSid,
                            thumbprint,
                            dateCreated,
                            dateUpdated);
    }
}