/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.hostedNumbers.authorizationdocument;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class DependentHostedNumberOrderReader extends Reader<DependentHostedNumberOrder> {
    private final String pathSigningDocumentSid;
    private DependentHostedNumberOrder.Status status;
    private com.twilio.type.PhoneNumber phoneNumber;
    private String incomingPhoneNumberSid;
    private String friendlyName;
    private String uniqueName;

    /**
     * Construct a new DependentHostedNumberOrderReader.
     *
     * @param pathSigningDocumentSid The signing_document_sid
     */
    public DependentHostedNumberOrderReader(final String pathSigningDocumentSid) {
        this.pathSigningDocumentSid = pathSigningDocumentSid;
    }

    /**
     * Status of an instance resource. It can hold one of the values: 1. opened 2.
     * signing, 3. signed LOA, 4. canceled, 5. failed. See the section entitled <a
     * href="https://www.twilio.com/docs/api/phone-numbers/hosted-number-authorization-documents#status-values">Status
     * Values</a> for more information on each of these statuses..
     *
     * @param status The Status of this HostedNumberOrder.
     * @return this
     */
    public DependentHostedNumberOrderReader setStatus(final DependentHostedNumberOrder.Status status) {
        this.status = status;
        return this;
    }

    /**
     * An E164 formatted phone number hosted by this HostedNumberOrder..
     *
     * @param phoneNumber An E164 formatted phone number.
     * @return this
     */
    public DependentHostedNumberOrderReader setPhoneNumber(final com.twilio.type.PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * An E164 formatted phone number hosted by this HostedNumberOrder..
     *
     * @param phoneNumber An E164 formatted phone number.
     * @return this
     */
    public DependentHostedNumberOrderReader setPhoneNumber(final String phoneNumber) {
        return setPhoneNumber(Promoter.phoneNumberFromString(phoneNumber));
    }

    /**
     * A 34 character string that uniquely identifies the IncomingPhoneNumber
     * resource created by this HostedNumberOrder..
     *
     * @param incomingPhoneNumberSid IncomingPhoneNumber sid.
     * @return this
     */
    public DependentHostedNumberOrderReader setIncomingPhoneNumberSid(final String incomingPhoneNumberSid) {
        this.incomingPhoneNumberSid = incomingPhoneNumberSid;
        return this;
    }

    /**
     * A human readable description of this resource, up to 64 characters..
     *
     * @param friendlyName A human readable description of this resource.
     * @return this
     */
    public DependentHostedNumberOrderReader setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * Provides a unique and addressable name to be assigned to this
     * HostedNumberOrder, assigned by the developer, to be optionally used in
     * addition to SID..
     *
     * @param uniqueName A unique, developer assigned name of this
     *                   HostedNumberOrder.
     * @return this
     */
    public DependentHostedNumberOrderReader setUniqueName(final String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return DependentHostedNumberOrder ResourceSet
     */
    @Override
    public ResourceSet<DependentHostedNumberOrder> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return DependentHostedNumberOrder ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<DependentHostedNumberOrder> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.PREVIEW.toString(),
            "/HostedNumbers/AuthorizationDocuments/" + this.pathSigningDocumentSid + "/DependentHostedNumberOrders"
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the target page from the Twilio API.
     *
     * @param targetUrl API-generated URL for the requested results page
     * @param client TwilioRestClient with which to make the request
     * @return DependentHostedNumberOrder ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<DependentHostedNumberOrder> getPage(final String targetUrl, final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            targetUrl
        );

        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<DependentHostedNumberOrder> nextPage(final Page<DependentHostedNumberOrder> page,
                                                     final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.PREVIEW.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the previous page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Previous Page
     */
    @Override
    public Page<DependentHostedNumberOrder> previousPage(final Page<DependentHostedNumberOrder> page,
                                                         final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.PREVIEW.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of DependentHostedNumberOrder Resources for a given request.
     *
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<DependentHostedNumberOrder> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("DependentHostedNumberOrder read failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
           throw new ApiException(restException);
        }

        return Page.fromJson(
            "items",
            response.getContent(),
            DependentHostedNumberOrder.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (status != null) {
            request.addQueryParam("Status", status.toString());
        }

        if (phoneNumber != null) {
            request.addQueryParam("PhoneNumber", phoneNumber.toString());
        }

        if (incomingPhoneNumberSid != null) {
            request.addQueryParam("IncomingPhoneNumberSid", incomingPhoneNumberSid);
        }

        if (friendlyName != null) {
            request.addQueryParam("FriendlyName", friendlyName);
        }

        if (uniqueName != null) {
            request.addQueryParam("UniqueName", uniqueName);
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}