/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class BrandedChannel extends Resource {
    private static final long serialVersionUID = 119049791747662L;

    /**
     * Create a BrandedChannelFetcher to execute fetch.
     *
     * @param pathSid Branded Channel Sid.
     * @return BrandedChannelFetcher capable of executing the fetch
     */
    public static BrandedChannelFetcher fetcher(final String pathSid) {
        return new BrandedChannelFetcher(pathSid);
    }

    /**
     * Converts a JSON String into a BrandedChannel object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return BrandedChannel object represented by the provided JSON
     */
    public static BrandedChannel fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BrandedChannel.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a BrandedChannel object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return BrandedChannel object represented by the provided JSON
     */
    public static BrandedChannel fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BrandedChannel.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String businessSid;
    private final String brandSid;
    private final String sid;
    private final Map<String, String> links;
    private final URI url;

    @JsonCreator
    private BrandedChannel(@JsonProperty("account_sid")
                           final String accountSid,
                           @JsonProperty("business_sid")
                           final String businessSid,
                           @JsonProperty("brand_sid")
                           final String brandSid,
                           @JsonProperty("sid")
                           final String sid,
                           @JsonProperty("links")
                           final Map<String, String> links,
                           @JsonProperty("url")
                           final URI url) {
        this.accountSid = accountSid;
        this.businessSid = businessSid;
        this.brandSid = brandSid;
        this.sid = sid;
        this.links = links;
        this.url = url;
    }

    /**
     * Returns Account Sid..
     *
     * @return Account Sid.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns Business Sid..
     *
     * @return Business Sid.
     */
    public final String getBusinessSid() {
        return this.businessSid;
    }

    /**
     * Returns Brand Sid..
     *
     * @return Brand Sid.
     */
    public final String getBrandSid() {
        return this.brandSid;
    }

    /**
     * Returns Branded Channel Sid..
     *
     * @return Branded Channel Sid.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns Nested resource URLs..
     *
     * @return Nested resource URLs.
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    /**
     * Returns The URL of this resource..
     *
     * @return The URL of this resource.
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        BrandedChannel other = (BrandedChannel) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(businessSid, other.businessSid) &&
               Objects.equals(brandSid, other.brandSid) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(links, other.links) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            businessSid,
                            brandSid,
                            sid,
                            links,
                            url);
    }
}