/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.trustedComms.brandedchannel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Channel extends Resource {
    private static final long serialVersionUID = 99311524255768L;

    /**
     * Create a ChannelCreator to execute create.
     *
     * @param pathBrandedChannelSid Branded Channel Sid.
     * @param phoneNumberSid Phone Number Sid to be branded.
     * @return ChannelCreator capable of executing the create
     */
    public static ChannelCreator creator(final String pathBrandedChannelSid,
                                         final String phoneNumberSid) {
        return new ChannelCreator(pathBrandedChannelSid, phoneNumberSid);
    }

    /**
     * Converts a JSON String into a Channel object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Channel object represented by the provided JSON
     */
    public static Channel fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Channel.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Channel object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Channel object represented by the provided JSON
     */
    public static Channel fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Channel.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String businessSid;
    private final String brandSid;
    private final String brandedChannelSid;
    private final String phoneNumberSid;
    private final String phoneNumber;
    private final URI url;

    @JsonCreator
    private Channel(@JsonProperty("account_sid")
                    final String accountSid,
                    @JsonProperty("business_sid")
                    final String businessSid,
                    @JsonProperty("brand_sid")
                    final String brandSid,
                    @JsonProperty("branded_channel_sid")
                    final String brandedChannelSid,
                    @JsonProperty("phone_number_sid")
                    final String phoneNumberSid,
                    @JsonProperty("phone_number")
                    final String phoneNumber,
                    @JsonProperty("url")
                    final URI url) {
        this.accountSid = accountSid;
        this.businessSid = businessSid;
        this.brandSid = brandSid;
        this.brandedChannelSid = brandedChannelSid;
        this.phoneNumberSid = phoneNumberSid;
        this.phoneNumber = phoneNumber;
        this.url = url;
    }

    /**
     * Returns Account Sid..
     *
     * @return Account Sid.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns Business Sid..
     *
     * @return Business Sid.
     */
    public final String getBusinessSid() {
        return this.businessSid;
    }

    /**
     * Returns Brand Sid..
     *
     * @return Brand Sid.
     */
    public final String getBrandSid() {
        return this.brandSid;
    }

    /**
     * Returns Branded Channel Sid..
     *
     * @return Branded Channel Sid.
     */
    public final String getBrandedChannelSid() {
        return this.brandedChannelSid;
    }

    /**
     * Returns Phone Number Sid to be branded..
     *
     * @return Phone Number Sid to be branded.
     */
    public final String getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    /**
     * Returns Twilio number to assign to the Branded Channel.
     *
     * @return Twilio number to assign to the Branded Channel
     */
    public final String getPhoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Returns The URL of this resource..
     *
     * @return The URL of this resource.
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Channel other = (Channel) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(businessSid, other.businessSid) &&
               Objects.equals(brandSid, other.brandSid) &&
               Objects.equals(brandedChannelSid, other.brandedChannelSid) &&
               Objects.equals(phoneNumberSid, other.phoneNumberSid) &&
               Objects.equals(phoneNumber, other.phoneNumber) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            businessSid,
                            brandSid,
                            brandedChannelSid,
                            phoneNumberSid,
                            phoneNumber,
                            url);
    }
}