/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class QueryCreator extends Creator<Query> {
    private final String pathAssistantSid;
    private final String language;
    private final String query;
    private String tasks;
    private String modelBuild;
    private String field;

    /**
     * Construct a new QueryCreator.
     *
     * @param pathAssistantSid The unique ID of the parent Assistant.
     * @param language An ISO language-country string of the sample.
     * @param query A user-provided string that uniquely identifies this resource
     *              as an alternative to the sid. It can be up to 2048 characters
     *              long.
     */
    public QueryCreator(final String pathAssistantSid,
                        final String language,
                        final String query) {
        this.pathAssistantSid = pathAssistantSid;
        this.language = language;
        this.query = query;
    }

    /**
     * Constraints the query to a set of tasks. Useful when you need to constrain
     * the paths the user can take. Tasks should be comma separated
     * *task-unique-name-1*, *task-unique-name-2*.
     *
     * @param tasks Constraints the query to a set of tasks. Useful when you need
     *              to constrain the paths the user can take. Tasks should be comma
     *              separated task-unique-name-1, task-unique-name-2
     * @return this
     */
    public QueryCreator setTasks(final String tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * The Model Build Sid or unique name of the Model Build to be queried..
     *
     * @param modelBuild The Model Build Sid or unique name of the Model Build to
     *                   be queried.
     * @return this
     */
    public QueryCreator setModelBuild(final String modelBuild) {
        this.modelBuild = modelBuild;
        return this;
    }

    /**
     * Constraints the query to a given Field with an task. Useful when you know the
     * Field you are expecting. It accepts one field in the format
     * *task-unique-name-1*:*field-unique-name*.
     *
     * @param field Constraints the query to a given Field with an task. Useful
     *              when you know the Field you are expecting. It accepts one field
     *              in the format task-unique-name-1:field-unique-name
     * @return this
     */
    public QueryCreator setField(final String field) {
        this.field = field;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Query
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Query create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PREVIEW.toString(),
            "/understand/Assistants/" + this.pathAssistantSid + "/Queries"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Query creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Query.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (language != null) {
            request.addPostParam("Language", language);
        }

        if (query != null) {
            request.addPostParam("Query", query);
        }

        if (tasks != null) {
            request.addPostParam("Tasks", tasks);
        }

        if (modelBuild != null) {
            request.addPostParam("ModelBuild", modelBuild.toString());
        }

        if (field != null) {
            request.addPostParam("Field", field);
        }
    }
}