/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.understand.assistant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class StyleSheet extends Resource {
    private static final long serialVersionUID = 3179724176697L;

    /**
     * Create a StyleSheetFetcher to execute fetch.
     *
     * @param pathAssistantSid The unique ID of the Assistant
     * @return StyleSheetFetcher capable of executing the fetch
     */
    public static StyleSheetFetcher fetcher(final String pathAssistantSid) {
        return new StyleSheetFetcher(pathAssistantSid);
    }

    /**
     * Create a StyleSheetUpdater to execute update.
     *
     * @param pathAssistantSid The unique ID of the Assistant
     * @return StyleSheetUpdater capable of executing the update
     */
    public static StyleSheetUpdater updater(final String pathAssistantSid) {
        return new StyleSheetUpdater(pathAssistantSid);
    }

    /**
     * Converts a JSON String into a StyleSheet object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return StyleSheet object represented by the provided JSON
     */
    public static StyleSheet fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, StyleSheet.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a StyleSheet object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return StyleSheet object represented by the provided JSON
     */
    public static StyleSheet fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, StyleSheet.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String assistantSid;
    private final URI url;
    private final Map<String, Object> data;

    @JsonCreator
    private StyleSheet(@JsonProperty("account_sid")
                       final String accountSid,
                       @JsonProperty("assistant_sid")
                       final String assistantSid,
                       @JsonProperty("url")
                       final URI url,
                       @JsonProperty("data")
                       final Map<String, Object> data) {
        this.accountSid = accountSid;
        this.assistantSid = assistantSid;
        this.url = url;
        this.data = data;
    }

    /**
     * Returns The unique ID of the Account that created this Assistant.
     *
     * @return The unique ID of the Account that created this Assistant
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The unique ID of the Assistant.
     *
     * @return The unique ID of the Assistant
     */
    public final String getAssistantSid() {
        return this.assistantSid;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The JSON style sheet object.
     *
     * @return The JSON style sheet object
     */
    public final Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        StyleSheet other = (StyleSheet) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(assistantSid, other.assistantSid) &&
               Objects.equals(url, other.url) &&
               Objects.equals(data, other.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            assistantSid,
                            url,
                            data);
    }
}