/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;
import java.util.Map;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class TaskUpdater extends Updater<Task> {
    private final String pathAssistantSid;
    private final String pathSid;
    private String friendlyName;
    private String uniqueName;
    private Map<String, Object> actions;
    private URI actionsUrl;

    /**
     * Construct a new TaskUpdater.
     *
     * @param pathAssistantSid The unique ID of the Assistant.
     * @param pathSid A 34 character string that uniquely identifies this resource.
     */
    public TaskUpdater(final String pathAssistantSid,
                       final String pathSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathSid = pathSid;
    }

    /**
     * A user-provided string that identifies this resource. It is non-unique and
     * can up to 255 characters long..
     *
     * @param friendlyName A user-provided string that identifies this resource. It
     *                     is non-unique and can up to 255 characters long.
     * @return this
     */
    public TaskUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * A user-provided string that uniquely identifies this resource as an
     * alternative to the sid. Unique up to 64 characters long..
     *
     * @param uniqueName A user-provided string that uniquely identifies this
     *                   resource as an alternative to the sid. Unique up to 64
     *                   characters long.
     * @return this
     */
    public TaskUpdater setUniqueName(final String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    /**
     * A user-provided JSON object encoded as a string to specify the actions for
     * this task. It is optional and non-unique..
     *
     * @param actions A user-provided JSON object encoded as a string to specify
     *                the actions for this task. It is optional and non-unique.
     * @return this
     */
    public TaskUpdater setActions(final Map<String, Object> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * User-provided HTTP endpoint where from the assistant fetches actions.
     *
     * @param actionsUrl User-provided HTTP endpoint where from the assistant
     *                   fetches actions
     * @return this
     */
    public TaskUpdater setActionsUrl(final URI actionsUrl) {
        this.actionsUrl = actionsUrl;
        return this;
    }

    /**
     * User-provided HTTP endpoint where from the assistant fetches actions.
     *
     * @param actionsUrl User-provided HTTP endpoint where from the assistant
     *                   fetches actions
     * @return this
     */
    public TaskUpdater setActionsUrl(final String actionsUrl) {
        return setActionsUrl(Promoter.uriFromString(actionsUrl));
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Task
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Task update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PREVIEW.toString(),
            "/understand/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Task update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }

        if (actions != null) {
            request.addPostParam("Actions", Converter.mapToJson(actions));
        }

        if (actionsUrl != null) {
            request.addPostParam("ActionsUrl", actionsUrl.toString());
        }
    }
}