/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.proxy.v1.service.session;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class ParticipantCreator extends Creator<Participant> {
    private final String pathServiceSid;
    private final String pathSessionSid;
    private final String identifier;
    private String friendlyName;
    private String proxyIdentifier;
    private String proxyIdentifierSid;
    private Boolean failOnParticipantConflict;

    /**
     * Construct a new ParticipantCreator.
     *
     * @param pathServiceSid The SID of the parent Service resource
     * @param pathSessionSid The SID of the parent Session resource
     * @param identifier The phone number of the Participant
     */
    public ParticipantCreator(final String pathServiceSid,
                              final String pathSessionSid,
                              final String identifier) {
        this.pathServiceSid = pathServiceSid;
        this.pathSessionSid = pathSessionSid;
        this.identifier = identifier;
    }

    /**
     * The string that you assigned to describe the participant. This value must be
     * 255 characters or fewer. **This value should not have PII.**.
     *
     * @param friendlyName The string that you assigned to describe the participant
     * @return this
     */
    public ParticipantCreator setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The proxy phone number to use for the Participant. If not specified, Proxy
     * will select a number from the pool..
     *
     * @param proxyIdentifier The proxy phone number to use for the Participant
     * @return this
     */
    public ParticipantCreator setProxyIdentifier(final String proxyIdentifier) {
        this.proxyIdentifier = proxyIdentifier;
        return this;
    }

    /**
     * The SID of the Proxy Identifier to assign to the Participant..
     *
     * @param proxyIdentifierSid The Proxy Identifier Sid
     * @return this
     */
    public ParticipantCreator setProxyIdentifierSid(final String proxyIdentifierSid) {
        this.proxyIdentifierSid = proxyIdentifierSid;
        return this;
    }

    /**
     * [Experimental] For accounts with the ProxyAllowParticipantConflict account
     * flag, setting to true enables per-request opt-in to allowing Proxy to reject
     * a Participant create request that could cause the same
     * Identifier/ProxyIdentifier pair to be active in multiple Sessions. Depending
     * on the context, this could be a 409 error (Twilio error code 80623) or a 400
     * error (Twilio error code 80604). If not provided, requests will be allowed to
     * succeed and a Debugger notification (80802) will be emitted. Having multiple,
     * active Participants with the same Identifier/ProxyIdentifier pair causes
     * calls and messages from affected Participants to be routed incorrectly.
     * Please note, the default behavior for accounts without the
     * ProxyAllowParticipantConflict flag is to reject the request as described.
     * This will eventually be the default for all accounts..
     *
     * @param failOnParticipantConflict An experimental parameter to override the
     *                                  ProxyAllowParticipantConflict account flag
     *                                  on a per-request basis.
     * @return this
     */
    public ParticipantCreator setFailOnParticipantConflict(final Boolean failOnParticipantConflict) {
        this.failOnParticipantConflict = failOnParticipantConflict;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Participant
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Participant create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PROXY.toString(),
            "/v1/Services/" + this.pathServiceSid + "/Sessions/" + this.pathSessionSid + "/Participants"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (identifier != null) {
            request.addPostParam("Identifier", identifier);
        }

        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (proxyIdentifier != null) {
            request.addPostParam("ProxyIdentifier", proxyIdentifier);
        }

        if (proxyIdentifierSid != null) {
            request.addPostParam("ProxyIdentifierSid", proxyIdentifierSid);
        }

        if (failOnParticipantConflict != null) {
            request.addPostParam("FailOnParticipantConflict", failOnParticipantConflict.toString());
        }
    }
}