/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.serverless.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Function extends Resource {
    private static final long serialVersionUID = 37942173237399L;

    /**
     * Create a FunctionReader to execute read.
     *
     * @param pathServiceSid The SID of the Service to read the Function resources
     *                       from
     * @return FunctionReader capable of executing the read
     */
    public static FunctionReader reader(final String pathServiceSid) {
        return new FunctionReader(pathServiceSid);
    }

    /**
     * Create a FunctionFetcher to execute fetch.
     *
     * @param pathServiceSid The SID of the Service to fetch the Function resource
     *                       from
     * @param pathSid The SID of the Function resource to fetch
     * @return FunctionFetcher capable of executing the fetch
     */
    public static FunctionFetcher fetcher(final String pathServiceSid,
                                          final String pathSid) {
        return new FunctionFetcher(pathServiceSid, pathSid);
    }

    /**
     * Create a FunctionDeleter to execute delete.
     *
     * @param pathServiceSid The SID of the Service to delete the Function resource
     *                       from
     * @param pathSid The SID of the Function resource to delete
     * @return FunctionDeleter capable of executing the delete
     */
    public static FunctionDeleter deleter(final String pathServiceSid,
                                          final String pathSid) {
        return new FunctionDeleter(pathServiceSid, pathSid);
    }

    /**
     * Create a FunctionCreator to execute create.
     *
     * @param pathServiceSid The SID of the Service to create the Function resource
     *                       under
     * @param friendlyName A string to describe the Function resource
     * @return FunctionCreator capable of executing the create
     */
    public static FunctionCreator creator(final String pathServiceSid,
                                          final String friendlyName) {
        return new FunctionCreator(pathServiceSid, friendlyName);
    }

    /**
     * Create a FunctionUpdater to execute update.
     *
     * @param pathServiceSid The SID of the Service to update the Function resource
     *                       from
     * @param pathSid The SID of the Function resource to update
     * @param friendlyName A string to describe the Function resource
     * @return FunctionUpdater capable of executing the update
     */
    public static FunctionUpdater updater(final String pathServiceSid,
                                          final String pathSid,
                                          final String friendlyName) {
        return new FunctionUpdater(pathServiceSid, pathSid, friendlyName);
    }

    /**
     * Converts a JSON String into a Function object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Function object represented by the provided JSON
     */
    public static Function fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Function.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Function object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Function object represented by the provided JSON
     */
    public static Function fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Function.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String friendlyName;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Function(@JsonProperty("sid")
                     final String sid,
                     @JsonProperty("account_sid")
                     final String accountSid,
                     @JsonProperty("service_sid")
                     final String serviceSid,
                     @JsonProperty("friendly_name")
                     final String friendlyName,
                     @JsonProperty("date_created")
                     final String dateCreated,
                     @JsonProperty("date_updated")
                     final String dateUpdated,
                     @JsonProperty("url")
                     final URI url,
                     @JsonProperty("links")
                     final Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The unique string that identifies the Function resource.
     *
     * @return The unique string that identifies the Function resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account that created the Function resource.
     *
     * @return The SID of the Account that created the Function resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the Service that the Function resource is associated with.
     *
     * @return The SID of the Service that the Function resource is associated with
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns The string that you assigned to describe the Function resource.
     *
     * @return The string that you assigned to describe the Function resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the Function resource was
     * created.
     *
     * @return The ISO 8601 date and time in GMT when the Function resource was
     *         created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the Function resource was last
     * updated.
     *
     * @return The ISO 8601 date and time in GMT when the Function resource was
     *         last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the Function resource.
     *
     * @return The absolute URL of the Function resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The URLs of nested resources of the Function resource.
     *
     * @return The URLs of nested resources of the Function resource
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Function other = (Function) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(serviceSid, other.serviceSid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            serviceSid,
                            friendlyName,
                            dateCreated,
                            dateUpdated,
                            url,
                            links);
    }
}