/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.studio.v2;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.Map;

public class FlowCreator extends Creator<Flow> {
    private final String friendlyName;
    private final Flow.Status status;
    private final Map<String, Object> definition;
    private String commitMessage;

    /**
     * Construct a new FlowCreator.
     *
     * @param friendlyName The string that you assigned to describe the Flow
     * @param status The status of the Flow
     * @param definition JSON representation of flow definition
     */
    public FlowCreator(final String friendlyName,
                       final Flow.Status status,
                       final Map<String, Object> definition) {
        this.friendlyName = friendlyName;
        this.status = status;
        this.definition = definition;
    }

    /**
     * Description of change made in the revision..
     *
     * @param commitMessage Description of change made in the revision
     * @return this
     */
    public FlowCreator setCommitMessage(final String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Flow
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Flow create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.STUDIO.toString(),
            "/v2/Flows"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Flow creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Flow.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (status != null) {
            request.addPostParam("Status", status.toString());
        }

        if (definition != null) {
            request.addPostParam("Definition", Converter.mapToJson(definition));
        }

        if (commitMessage != null) {
            request.addPostParam("CommitMessage", commitMessage);
        }
    }
}