/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class EsimProfile extends Resource {
    private static final long serialVersionUID = 221129799677038L;

    public enum Status {
        NEW("new"),
        RESERVING("reserving"),
        AVAILABLE("available"),
        DOWNLOADED("downloaded"),
        INSTALLED("installed"),
        FAILED("failed");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    /**
     * Create a EsimProfileCreator to execute create.
     *
     * @return EsimProfileCreator capable of executing the create
     */
    public static EsimProfileCreator creator() {
        return new EsimProfileCreator();
    }

    /**
     * Create a EsimProfileFetcher to execute fetch.
     *
     * @param pathSid The SID of the eSIM Profile resource to fetch
     * @return EsimProfileFetcher capable of executing the fetch
     */
    public static EsimProfileFetcher fetcher(final String pathSid) {
        return new EsimProfileFetcher(pathSid);
    }

    /**
     * Create a EsimProfileReader to execute read.
     *
     * @return EsimProfileReader capable of executing the read
     */
    public static EsimProfileReader reader() {
        return new EsimProfileReader();
    }

    /**
     * Converts a JSON String into a EsimProfile object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return EsimProfile object represented by the provided JSON
     */
    public static EsimProfile fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, EsimProfile.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a EsimProfile object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return EsimProfile object represented by the provided JSON
     */
    public static EsimProfile fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, EsimProfile.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String iccid;
    private final String simSid;
    private final EsimProfile.Status status;
    private final String eid;
    private final URI smdpPlusAddress;
    private final String errorCode;
    private final String errorMessage;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private EsimProfile(@JsonProperty("sid")
                        final String sid,
                        @JsonProperty("account_sid")
                        final String accountSid,
                        @JsonProperty("iccid")
                        final String iccid,
                        @JsonProperty("sim_sid")
                        final String simSid,
                        @JsonProperty("status")
                        final EsimProfile.Status status,
                        @JsonProperty("eid")
                        final String eid,
                        @JsonProperty("smdp_plus_address")
                        final URI smdpPlusAddress,
                        @JsonProperty("error_code")
                        final String errorCode,
                        @JsonProperty("error_message")
                        final String errorMessage,
                        @JsonProperty("date_created")
                        final String dateCreated,
                        @JsonProperty("date_updated")
                        final String dateUpdated,
                        @JsonProperty("url")
                        final URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.iccid = iccid;
        this.simSid = simSid;
        this.status = status;
        this.eid = eid;
        this.smdpPlusAddress = smdpPlusAddress;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account to which the eSIM Profile resource belongs.
     *
     * @return The SID of the Account to which the eSIM Profile resource belongs
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The ICCID associated with the Sim resource.
     *
     * @return The ICCID associated with the Sim resource
     */
    public final String getIccid() {
        return this.iccid;
    }

    /**
     * Returns The SID of the Sim resource that this eSIM Profile controls.
     *
     * @return The SID of the Sim resource that this eSIM Profile controls
     */
    public final String getSimSid() {
        return this.simSid;
    }

    /**
     * Returns The status of the eSIM Profile.
     *
     * @return The status of the eSIM Profile
     */
    public final EsimProfile.Status getStatus() {
        return this.status;
    }

    /**
     * Returns Identifier of the eUICC that can claim the eSIM Profile.
     *
     * @return Identifier of the eUICC that can claim the eSIM Profile
     */
    public final String getEid() {
        return this.eid;
    }

    /**
     * Returns Address of the SM-DP+ server from which the Profile will be
     * downloaded.
     *
     * @return Address of the SM-DP+ server from which the Profile will be
     *         downloaded
     */
    public final URI getSmdpPlusAddress() {
        return this.smdpPlusAddress;
    }

    /**
     * Returns Code indicating the failure if the download of the SIM Profile failed
     * and the eSIM Profile is in `failed` state.
     *
     * @return Code indicating the failure if the download of the SIM Profile
     *         failed and the eSIM Profile is in `failed` state
     */
    public final String getErrorCode() {
        return this.errorCode;
    }

    /**
     * Returns Error message describing the failure if the download of the SIM
     * Profile failed and the eSIM Profile is in `failed` state.
     *
     * @return Error message describing the failure if the download of the SIM
     *         Profile failed and the eSIM Profile is in `failed` state
     */
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the eSIM Profile resource.
     *
     * @return The absolute URL of the eSIM Profile resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        EsimProfile other = (EsimProfile) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(iccid, other.iccid) &&
               Objects.equals(simSid, other.simSid) &&
               Objects.equals(status, other.status) &&
               Objects.equals(eid, other.eid) &&
               Objects.equals(smdpPlusAddress, other.smdpPlusAddress) &&
               Objects.equals(errorCode, other.errorCode) &&
               Objects.equals(errorMessage, other.errorMessage) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            iccid,
                            simSid,
                            status,
                            eid,
                            smdpPlusAddress,
                            errorCode,
                            errorMessage,
                            dateCreated,
                            dateUpdated,
                            url);
    }
}