/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class EsimProfileCreator extends Creator<EsimProfile> {
    private String callbackUrl;
    private HttpMethod callbackMethod;
    private String eid;

    /**
     * The URL we should call using the `callback_method` when the status of the
     * eSIM Profile changes. At this stage of the eSIM Profile pilot, the a request
     * to the URL will only be called when the ESimProfile resource changes from
     * `reserving` to `available`..
     *
     * @param callbackUrl The URL we should call after we have sent when the status
     *                    of the eSIM Profile changes
     * @return this
     */
    public EsimProfileCreator setCallbackUrl(final String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    /**
     * The HTTP method we should use to call `callback_url`. Can be: `GET` or `POST`
     * and the default is POST..
     *
     * @param callbackMethod The HTTP method we should use to call callback_url
     * @return this
     */
    public EsimProfileCreator setCallbackMethod(final HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    /**
     * Identifier of the eUICC that will claim the eSIM Profile..
     *
     * @param eid Identifier of the eUICC that will claim the eSIM Profile
     * @return this
     */
    public EsimProfileCreator setEid(final String eid) {
        this.eid = eid;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created EsimProfile
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public EsimProfile create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.SUPERSIM.toString(),
            "/v1/ESimProfiles"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("EsimProfile creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return EsimProfile.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (callbackUrl != null) {
            request.addPostParam("CallbackUrl", callbackUrl);
        }

        if (callbackMethod != null) {
            request.addPostParam("CallbackMethod", callbackMethod.toString());
        }

        if (eid != null) {
            request.addPostParam("Eid", eid);
        }
    }
}