/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class EsimProfileReader extends Reader<EsimProfile> {
    private String eid;
    private String simSid;
    private EsimProfile.Status status;

    /**
     * List the eSIM Profiles that have been associated with an EId..
     *
     * @param eid List the eSIM Profiles that have been associated with an EId
     * @return this
     */
    public EsimProfileReader setEid(final String eid) {
        this.eid = eid;
        return this;
    }

    /**
     * Find the eSIM Profile resource related to a <a
     * href="https://www.twilio.com/docs/wireless/api/sim-resource">Sim</a> resource
     * by providing the SIM SID. Will always return an array with either 1 or 0
     * records..
     *
     * @param simSid Find the eSIM Profile resource related to a Sim resource by
     *               providing the SIM SID
     * @return this
     */
    public EsimProfileReader setSimSid(final String simSid) {
        this.simSid = simSid;
        return this;
    }

    /**
     * List the eSIM Profiles that are in a given status..
     *
     * @param status List the eSIM Profiles that are in a given status
     * @return this
     */
    public EsimProfileReader setStatus(final EsimProfile.Status status) {
        this.status = status;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return EsimProfile ResourceSet
     */
    @Override
    public ResourceSet<EsimProfile> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return EsimProfile ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<EsimProfile> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.SUPERSIM.toString(),
            "/v1/ESimProfiles"
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the target page from the Twilio API.
     *
     * @param targetUrl API-generated URL for the requested results page
     * @param client TwilioRestClient with which to make the request
     * @return EsimProfile ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<EsimProfile> getPage(final String targetUrl, final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            targetUrl
        );

        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<EsimProfile> nextPage(final Page<EsimProfile> page,
                                      final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.SUPERSIM.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the previous page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Previous Page
     */
    @Override
    public Page<EsimProfile> previousPage(final Page<EsimProfile> page,
                                          final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.SUPERSIM.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of EsimProfile Resources for a given request.
     *
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<EsimProfile> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("EsimProfile read failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
           throw new ApiException(restException);
        }

        return Page.fromJson(
            "esim_profiles",
            response.getContent(),
            EsimProfile.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (eid != null) {
            request.addQueryParam("Eid", eid);
        }

        if (simSid != null) {
            request.addQueryParam("SimSid", simSid.toString());
        }

        if (status != null) {
            request.addQueryParam("Status", status.toString());
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}