/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Network extends Resource {
    private static final long serialVersionUID = 60909399655489L;

    /**
     * Create a NetworkFetcher to execute fetch.
     *
     * @param pathSid The SID of the Network resource to fetch
     * @return NetworkFetcher capable of executing the fetch
     */
    public static NetworkFetcher fetcher(final String pathSid) {
        return new NetworkFetcher(pathSid);
    }

    /**
     * Create a NetworkReader to execute read.
     *
     * @return NetworkReader capable of executing the read
     */
    public static NetworkReader reader() {
        return new NetworkReader();
    }

    /**
     * Converts a JSON String into a Network object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Network object represented by the provided JSON
     */
    public static Network fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Network.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Network object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Network object represented by the provided JSON
     */
    public static Network fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Network.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String friendlyName;
    private final URI url;
    private final String isoCountry;
    private final List<Map<String, Object>> identifiers;

    @JsonCreator
    private Network(@JsonProperty("sid")
                    final String sid,
                    @JsonProperty("friendly_name")
                    final String friendlyName,
                    @JsonProperty("url")
                    final URI url,
                    @JsonProperty("iso_country")
                    final String isoCountry,
                    @JsonProperty("identifiers")
                    final List<Map<String, Object>> identifiers) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.url = url;
        this.isoCountry = isoCountry;
        this.identifiers = identifiers;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns A human readable identifier of this resource.
     *
     * @return A human readable identifier of this resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The absolute URL of the Network resource.
     *
     * @return The absolute URL of the Network resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The ISO country code of the Network resource.
     *
     * @return The ISO country code of the Network resource
     */
    public final String getIsoCountry() {
        return this.isoCountry;
    }

    /**
     * Returns The MCC/MNCs included in the Network resource.
     *
     * @return The MCC/MNCs included in the Network resource
     */
    public final List<Map<String, Object>> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Network other = (Network) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(url, other.url) &&
               Objects.equals(isoCountry, other.isoCountry) &&
               Objects.equals(identifiers, other.identifiers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            friendlyName,
                            url,
                            isoCountry,
                            identifiers);
    }
}