/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class NetworkAccessProfile extends Resource {
    private static final long serialVersionUID = 248233981028647L;

    /**
     * Create a NetworkAccessProfileCreator to execute create.
     *
     * @return NetworkAccessProfileCreator capable of executing the create
     */
    public static NetworkAccessProfileCreator creator() {
        return new NetworkAccessProfileCreator();
    }

    /**
     * Create a NetworkAccessProfileFetcher to execute fetch.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @return NetworkAccessProfileFetcher capable of executing the fetch
     */
    public static NetworkAccessProfileFetcher fetcher(final String pathSid) {
        return new NetworkAccessProfileFetcher(pathSid);
    }

    /**
     * Create a NetworkAccessProfileUpdater to execute update.
     *
     * @param pathSid The SID of the resource to update
     * @return NetworkAccessProfileUpdater capable of executing the update
     */
    public static NetworkAccessProfileUpdater updater(final String pathSid) {
        return new NetworkAccessProfileUpdater(pathSid);
    }

    /**
     * Create a NetworkAccessProfileReader to execute read.
     *
     * @return NetworkAccessProfileReader capable of executing the read
     */
    public static NetworkAccessProfileReader reader() {
        return new NetworkAccessProfileReader();
    }

    /**
     * Converts a JSON String into a NetworkAccessProfile object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return NetworkAccessProfile object represented by the provided JSON
     */
    public static NetworkAccessProfile fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, NetworkAccessProfile.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a NetworkAccessProfile object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return NetworkAccessProfile object represented by the provided JSON
     */
    public static NetworkAccessProfile fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, NetworkAccessProfile.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private NetworkAccessProfile(@JsonProperty("sid")
                                 final String sid,
                                 @JsonProperty("unique_name")
                                 final String uniqueName,
                                 @JsonProperty("account_sid")
                                 final String accountSid,
                                 @JsonProperty("date_created")
                                 final String dateCreated,
                                 @JsonProperty("date_updated")
                                 final String dateUpdated,
                                 @JsonProperty("url")
                                 final URI url,
                                 @JsonProperty("links")
                                 final Map<String, String> links) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns An application-defined string that uniquely identifies the resource.
     *
     * @return An application-defined string that uniquely identifies the resource
     */
    public final String getUniqueName() {
        return this.uniqueName;
    }

    /**
     * Returns The SID of the Account that the Network Access Profile belongs to.
     *
     * @return The SID of the Account that the Network Access Profile belongs to
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The links.
     *
     * @return The links
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        NetworkAccessProfile other = (NetworkAccessProfile) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(uniqueName, other.uniqueName) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            uniqueName,
                            accountSid,
                            dateCreated,
                            dateUpdated,
                            url,
                            links);
    }
}