/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class NetworkAccessProfileCreator extends Creator<NetworkAccessProfile> {
    private String uniqueName;
    private List<String> networks;

    /**
     * An application-defined string that uniquely identifies the resource. It can
     * be used in place of the resource's `sid` in the URL to address the resource..
     *
     * @param uniqueName An application-defined string that uniquely identifies the
     *                   resource
     * @return this
     */
    public NetworkAccessProfileCreator setUniqueName(final String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    /**
     * List of Network SIDs that this Network Access Profile will allow connections
     * to..
     *
     * @param networks List of Network SIDs that this Network Access Profile will
     *                 allow connections to
     * @return this
     */
    public NetworkAccessProfileCreator setNetworks(final List<String> networks) {
        this.networks = networks;
        return this;
    }

    /**
     * List of Network SIDs that this Network Access Profile will allow connections
     * to..
     *
     * @param networks List of Network SIDs that this Network Access Profile will
     *                 allow connections to
     * @return this
     */
    public NetworkAccessProfileCreator setNetworks(final String networks) {
        return setNetworks(Promoter.listOfOne(networks));
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created NetworkAccessProfile
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public NetworkAccessProfile create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.SUPERSIM.toString(),
            "/v1/NetworkAccessProfiles"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("NetworkAccessProfile creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return NetworkAccessProfile.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }

        if (networks != null) {
            for (String prop : networks) {
                request.addPostParam("Networks", prop.toString());
            }
        }
    }
}