/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.supersim.v1.networkaccessprofile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class NetworkAccessProfileNetwork extends Resource {
    private static final long serialVersionUID = 26561188761279L;

    /**
     * Create a NetworkAccessProfileNetworkReader to execute read.
     *
     * @param pathNetworkAccessProfileSid The unique string that identifies the
     *                                    Network Access Profile resource
     * @return NetworkAccessProfileNetworkReader capable of executing the read
     */
    public static NetworkAccessProfileNetworkReader reader(final String pathNetworkAccessProfileSid) {
        return new NetworkAccessProfileNetworkReader(pathNetworkAccessProfileSid);
    }

    /**
     * Create a NetworkAccessProfileNetworkCreator to execute create.
     *
     * @param pathNetworkAccessProfileSid The unique string that identifies the
     *                                    Network Access Profile resource
     * @param network The SID that identifies the Network resource
     * @return NetworkAccessProfileNetworkCreator capable of executing the create
     */
    public static NetworkAccessProfileNetworkCreator creator(final String pathNetworkAccessProfileSid,
                                                             final String network) {
        return new NetworkAccessProfileNetworkCreator(pathNetworkAccessProfileSid, network);
    }

    /**
     * Create a NetworkAccessProfileNetworkDeleter to execute delete.
     *
     * @param pathNetworkAccessProfileSid The unique string that identifies the
     *                                    Network Access Profile resource
     * @param pathSid The SID that identifies the Network resource
     * @return NetworkAccessProfileNetworkDeleter capable of executing the delete
     */
    public static NetworkAccessProfileNetworkDeleter deleter(final String pathNetworkAccessProfileSid,
                                                             final String pathSid) {
        return new NetworkAccessProfileNetworkDeleter(pathNetworkAccessProfileSid, pathSid);
    }

    /**
     * Create a NetworkAccessProfileNetworkFetcher to execute fetch.
     *
     * @param pathNetworkAccessProfileSid The unique string that identifies the
     *                                    Network Access Profile resource
     * @param pathSid The SID of the resource to fetch
     * @return NetworkAccessProfileNetworkFetcher capable of executing the fetch
     */
    public static NetworkAccessProfileNetworkFetcher fetcher(final String pathNetworkAccessProfileSid,
                                                             final String pathSid) {
        return new NetworkAccessProfileNetworkFetcher(pathNetworkAccessProfileSid, pathSid);
    }

    /**
     * Converts a JSON String into a NetworkAccessProfileNetwork object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return NetworkAccessProfileNetwork object represented by the provided JSON
     */
    public static NetworkAccessProfileNetwork fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, NetworkAccessProfileNetwork.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a NetworkAccessProfileNetwork object using
     * the provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return NetworkAccessProfileNetwork object represented by the provided JSON
     */
    public static NetworkAccessProfileNetwork fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, NetworkAccessProfileNetwork.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String networkAccessProfileSid;
    private final String friendlyName;
    private final String isoCountry;
    private final List<Map<String, Object>> identifiers;
    private final URI url;

    @JsonCreator
    private NetworkAccessProfileNetwork(@JsonProperty("sid")
                                        final String sid,
                                        @JsonProperty("network_access_profile_sid")
                                        final String networkAccessProfileSid,
                                        @JsonProperty("friendly_name")
                                        final String friendlyName,
                                        @JsonProperty("iso_country")
                                        final String isoCountry,
                                        @JsonProperty("identifiers")
                                        final List<Map<String, Object>> identifiers,
                                        @JsonProperty("url")
                                        final URI url) {
        this.sid = sid;
        this.networkAccessProfileSid = networkAccessProfileSid;
        this.friendlyName = friendlyName;
        this.isoCountry = isoCountry;
        this.identifiers = identifiers;
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The unique string that identifies the Network Access Profile
     * resource.
     *
     * @return The unique string that identifies the Network Access Profile resource
     */
    public final String getNetworkAccessProfileSid() {
        return this.networkAccessProfileSid;
    }

    /**
     * Returns A human readable identifier of this resource.
     *
     * @return A human readable identifier of this resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns The ISO country code of the Network resource.
     *
     * @return The ISO country code of the Network resource
     */
    public final String getIsoCountry() {
        return this.isoCountry;
    }

    /**
     * Returns The MCC/MNCs included in the resource.
     *
     * @return The MCC/MNCs included in the resource
     */
    public final List<Map<String, Object>> getIdentifiers() {
        return this.identifiers;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        NetworkAccessProfileNetwork other = (NetworkAccessProfileNetwork) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(networkAccessProfileSid, other.networkAccessProfileSid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(isoCountry, other.isoCountry) &&
               Objects.equals(identifiers, other.identifiers) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            networkAccessProfileSid,
                            friendlyName,
                            isoCountry,
                            identifiers,
                            url);
    }
}