/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.sync.v1.service;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class SyncListUpdater extends Updater<SyncList> {
    private final String pathServiceSid;
    private final String pathSid;
    private Integer ttl;
    private Integer collectionTtl;

    /**
     * Construct a new SyncListUpdater.
     *
     * @param pathServiceSid The SID of the Sync Service with the Sync List
     *                       resource to update
     * @param pathSid The SID of the Sync List resource to update
     */
    public SyncListUpdater(final String pathServiceSid,
                           final String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    /**
     * An alias for `collection_ttl`. If both are provided, this value is ignored..
     *
     * @param ttl An alias for collection_ttl
     * @return this
     */
    public SyncListUpdater setTtl(final Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    /**
     * How long, <a
     * href="https://www.twilio.com/docs/sync/limits#sync-payload-limits">in
     * seconds</a>, before the Sync List expires (time-to-live) and is deleted..
     *
     * @param collectionTtl How long, in seconds, before the Sync List expires and
     *                      is deleted
     * @return this
     */
    public SyncListUpdater setCollectionTtl(final Integer collectionTtl) {
        this.collectionTtl = collectionTtl;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated SyncList
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public SyncList update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.SYNC.toString(),
            "/v1/Services/" + this.pathServiceSid + "/Lists/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("SyncList update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return SyncList.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (ttl != null) {
            request.addPostParam("Ttl", ttl.toString());
        }

        if (collectionTtl != null) {
            request.addPostParam("CollectionTtl", collectionTtl.toString());
        }
    }
}