/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class ActivityCreator extends Creator<Activity> {
    private final String pathWorkspaceSid;
    private final String friendlyName;
    private Boolean available;

    /**
     * Construct a new ActivityCreator.
     *
     * @param pathWorkspaceSid The SID of the Workspace that the new Activity
     *                         belongs to
     * @param friendlyName A string to describe the Activity resource
     */
    public ActivityCreator(final String pathWorkspaceSid,
                           final String friendlyName) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.friendlyName = friendlyName;
    }

    /**
     * Whether the Worker should be eligible to receive a Task when it occupies the
     * Activity. A value of `true`, `1`, or `yes` specifies the Activity is
     * available. All other values specify that it is not. The value cannot be
     * changed after the Activity is created..
     *
     * @param available Whether the Worker should be eligible to receive a Task
     *                  when it occupies the Activity
     * @return this
     */
    public ActivityCreator setAvailable(final Boolean available) {
        this.available = available;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Activity
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Activity create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TASKROUTER.toString(),
            "/v1/Workspaces/" + this.pathWorkspaceSid + "/Activities"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Activity creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Activity.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (available != null) {
            request.addPostParam("Available", available.toString());
        }
    }
}