/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class TaskChannelCreator extends Creator<TaskChannel> {
    private final String pathWorkspaceSid;
    private final String friendlyName;
    private final String uniqueName;
    private Boolean channelOptimizedRouting;

    /**
     * Construct a new TaskChannelCreator.
     *
     * @param pathWorkspaceSid The SID of the Workspace that the new Task Channel
     *                         belongs to
     * @param friendlyName A string to describe the Task Channel resource
     * @param uniqueName An application-defined string that uniquely identifies the
     *                   Task Channel
     */
    public TaskChannelCreator(final String pathWorkspaceSid,
                              final String friendlyName,
                              final String uniqueName) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.friendlyName = friendlyName;
        this.uniqueName = uniqueName;
    }

    /**
     * Whether the Task Channel should prioritize Workers that have been idle. If
     * `true`, Workers that have been idle the longest are prioritized..
     *
     * @param channelOptimizedRouting Whether the Task Channel should prioritize
     *                                Workers that have been idle
     * @return this
     */
    public TaskChannelCreator setChannelOptimizedRouting(final Boolean channelOptimizedRouting) {
        this.channelOptimizedRouting = channelOptimizedRouting;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created TaskChannel
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public TaskChannel create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TASKROUTER.toString(),
            "/v1/Workspaces/" + this.pathWorkspaceSid + "/TaskChannels"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("TaskChannel creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return TaskChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }

        if (channelOptimizedRouting != null) {
            request.addPostParam("ChannelOptimizedRouting", channelOptimizedRouting.toString());
        }
    }
}