/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class WorkspaceRealTimeStatistics extends Resource {
    private static final long serialVersionUID = 18728955594793L;

    /**
     * Create a WorkspaceRealTimeStatisticsFetcher to execute fetch.
     *
     * @param pathWorkspaceSid The SID of the Workspace to fetch
     * @return WorkspaceRealTimeStatisticsFetcher capable of executing the fetch
     */
    public static WorkspaceRealTimeStatisticsFetcher fetcher(final String pathWorkspaceSid) {
        return new WorkspaceRealTimeStatisticsFetcher(pathWorkspaceSid);
    }

    /**
     * Converts a JSON String into a WorkspaceRealTimeStatistics object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return WorkspaceRealTimeStatistics object represented by the provided JSON
     */
    public static WorkspaceRealTimeStatistics fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, WorkspaceRealTimeStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a WorkspaceRealTimeStatistics object using
     * the provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return WorkspaceRealTimeStatistics object represented by the provided JSON
     */
    public static WorkspaceRealTimeStatistics fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, WorkspaceRealTimeStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final List<Map<String, Object>> activityStatistics;
    private final Integer longestTaskWaitingAge;
    private final String longestTaskWaitingSid;
    private final Map<String, Object> tasksByPriority;
    private final Map<String, Object> tasksByStatus;
    private final Integer totalTasks;
    private final Integer totalWorkers;
    private final String workspaceSid;
    private final URI url;

    @JsonCreator
    private WorkspaceRealTimeStatistics(@JsonProperty("account_sid")
                                        final String accountSid,
                                        @JsonProperty("activity_statistics")
                                        final List<Map<String, Object>> activityStatistics,
                                        @JsonProperty("longest_task_waiting_age")
                                        final Integer longestTaskWaitingAge,
                                        @JsonProperty("longest_task_waiting_sid")
                                        final String longestTaskWaitingSid,
                                        @JsonProperty("tasks_by_priority")
                                        final Map<String, Object> tasksByPriority,
                                        @JsonProperty("tasks_by_status")
                                        final Map<String, Object> tasksByStatus,
                                        @JsonProperty("total_tasks")
                                        final Integer totalTasks,
                                        @JsonProperty("total_workers")
                                        final Integer totalWorkers,
                                        @JsonProperty("workspace_sid")
                                        final String workspaceSid,
                                        @JsonProperty("url")
                                        final URI url) {
        this.accountSid = accountSid;
        this.activityStatistics = activityStatistics;
        this.longestTaskWaitingAge = longestTaskWaitingAge;
        this.longestTaskWaitingSid = longestTaskWaitingSid;
        this.tasksByPriority = tasksByPriority;
        this.tasksByStatus = tasksByStatus;
        this.totalTasks = totalTasks;
        this.totalWorkers = totalWorkers;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The number of current Workers by Activity.
     *
     * @return The number of current Workers by Activity
     */
    public final List<Map<String, Object>> getActivityStatistics() {
        return this.activityStatistics;
    }

    /**
     * Returns The age of the longest waiting Task.
     *
     * @return The age of the longest waiting Task
     */
    public final Integer getLongestTaskWaitingAge() {
        return this.longestTaskWaitingAge;
    }

    /**
     * Returns The SID of the longest waiting Task.
     *
     * @return The SID of the longest waiting Task
     */
    public final String getLongestTaskWaitingSid() {
        return this.longestTaskWaitingSid;
    }

    /**
     * Returns The number of Tasks by priority.
     *
     * @return The number of Tasks by priority
     */
    public final Map<String, Object> getTasksByPriority() {
        return this.tasksByPriority;
    }

    /**
     * Returns The number of Tasks by their current status.
     *
     * @return The number of Tasks by their current status
     */
    public final Map<String, Object> getTasksByStatus() {
        return this.tasksByStatus;
    }

    /**
     * Returns The total number of Tasks.
     *
     * @return The total number of Tasks
     */
    public final Integer getTotalTasks() {
        return this.totalTasks;
    }

    /**
     * Returns The total number of Workers in the Workspace.
     *
     * @return The total number of Workers in the Workspace
     */
    public final Integer getTotalWorkers() {
        return this.totalWorkers;
    }

    /**
     * Returns The SID of the Workspace.
     *
     * @return The SID of the Workspace
     */
    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    /**
     * Returns The absolute URL of the Workspace statistics resource.
     *
     * @return The absolute URL of the Workspace statistics resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        WorkspaceRealTimeStatistics other = (WorkspaceRealTimeStatistics) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(activityStatistics, other.activityStatistics) &&
               Objects.equals(longestTaskWaitingAge, other.longestTaskWaitingAge) &&
               Objects.equals(longestTaskWaitingSid, other.longestTaskWaitingSid) &&
               Objects.equals(tasksByPriority, other.tasksByPriority) &&
               Objects.equals(tasksByStatus, other.tasksByStatus) &&
               Objects.equals(totalTasks, other.totalTasks) &&
               Objects.equals(totalWorkers, other.totalWorkers) &&
               Objects.equals(workspaceSid, other.workspaceSid) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            activityStatistics,
                            longestTaskWaitingAge,
                            longestTaskWaitingSid,
                            tasksByPriority,
                            tasksByStatus,
                            totalTasks,
                            totalWorkers,
                            workspaceSid,
                            url);
    }
}