/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class WorkersCumulativeStatistics extends Resource {
    private static final long serialVersionUID = 89273605202076L;

    /**
     * Create a WorkersCumulativeStatisticsFetcher to execute fetch.
     *
     * @param pathWorkspaceSid The SID of the Workspace with the resource to fetch
     * @return WorkersCumulativeStatisticsFetcher capable of executing the fetch
     */
    public static WorkersCumulativeStatisticsFetcher fetcher(final String pathWorkspaceSid) {
        return new WorkersCumulativeStatisticsFetcher(pathWorkspaceSid);
    }

    /**
     * Converts a JSON String into a WorkersCumulativeStatistics object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return WorkersCumulativeStatistics object represented by the provided JSON
     */
    public static WorkersCumulativeStatistics fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, WorkersCumulativeStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a WorkersCumulativeStatistics object using
     * the provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return WorkersCumulativeStatistics object represented by the provided JSON
     */
    public static WorkersCumulativeStatistics fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, WorkersCumulativeStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final List<Map<String, Object>> activityDurations;
    private final Integer reservationsCreated;
    private final Integer reservationsAccepted;
    private final Integer reservationsRejected;
    private final Integer reservationsTimedOut;
    private final Integer reservationsCanceled;
    private final Integer reservationsRescinded;
    private final String workspaceSid;
    private final URI url;

    @JsonCreator
    private WorkersCumulativeStatistics(@JsonProperty("account_sid")
                                        final String accountSid,
                                        @JsonProperty("start_time")
                                        final String startTime,
                                        @JsonProperty("end_time")
                                        final String endTime,
                                        @JsonProperty("activity_durations")
                                        final List<Map<String, Object>> activityDurations,
                                        @JsonProperty("reservations_created")
                                        final Integer reservationsCreated,
                                        @JsonProperty("reservations_accepted")
                                        final Integer reservationsAccepted,
                                        @JsonProperty("reservations_rejected")
                                        final Integer reservationsRejected,
                                        @JsonProperty("reservations_timed_out")
                                        final Integer reservationsTimedOut,
                                        @JsonProperty("reservations_canceled")
                                        final Integer reservationsCanceled,
                                        @JsonProperty("reservations_rescinded")
                                        final Integer reservationsRescinded,
                                        @JsonProperty("workspace_sid")
                                        final String workspaceSid,
                                        @JsonProperty("url")
                                        final URI url) {
        this.accountSid = accountSid;
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.activityDurations = activityDurations;
        this.reservationsCreated = reservationsCreated;
        this.reservationsAccepted = reservationsAccepted;
        this.reservationsRejected = reservationsRejected;
        this.reservationsTimedOut = reservationsTimedOut;
        this.reservationsCanceled = reservationsCanceled;
        this.reservationsRescinded = reservationsRescinded;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The beginning of the interval during which these statistics were
     * calculated.
     *
     * @return The beginning of the interval during which these statistics were
     *         calculated
     */
    public final ZonedDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Returns The end of the interval during which these statistics were
     * calculated.
     *
     * @return The end of the interval during which these statistics were calculated
     */
    public final ZonedDateTime getEndTime() {
        return this.endTime;
    }

    /**
     * Returns The minimum, average, maximum, and total time that Workers spent in
     * each Activity.
     *
     * @return The minimum, average, maximum, and total time that Workers spent in
     *         each Activity
     */
    public final List<Map<String, Object>> getActivityDurations() {
        return this.activityDurations;
    }

    /**
     * Returns The total number of Reservations that were created.
     *
     * @return The total number of Reservations that were created
     */
    public final Integer getReservationsCreated() {
        return this.reservationsCreated;
    }

    /**
     * Returns The total number of Reservations that were accepted.
     *
     * @return The total number of Reservations that were accepted
     */
    public final Integer getReservationsAccepted() {
        return this.reservationsAccepted;
    }

    /**
     * Returns The total number of Reservations that were rejected.
     *
     * @return The total number of Reservations that were rejected
     */
    public final Integer getReservationsRejected() {
        return this.reservationsRejected;
    }

    /**
     * Returns The total number of Reservations that were timed out.
     *
     * @return The total number of Reservations that were timed out
     */
    public final Integer getReservationsTimedOut() {
        return this.reservationsTimedOut;
    }

    /**
     * Returns The total number of Reservations that were canceled.
     *
     * @return The total number of Reservations that were canceled
     */
    public final Integer getReservationsCanceled() {
        return this.reservationsCanceled;
    }

    /**
     * Returns The total number of Reservations that were rescinded.
     *
     * @return The total number of Reservations that were rescinded
     */
    public final Integer getReservationsRescinded() {
        return this.reservationsRescinded;
    }

    /**
     * Returns The SID of the Workspace that contains the Workers.
     *
     * @return The SID of the Workspace that contains the Workers
     */
    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    /**
     * Returns The absolute URL of the Workers statistics resource.
     *
     * @return The absolute URL of the Workers statistics resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        WorkersCumulativeStatistics other = (WorkersCumulativeStatistics) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(startTime, other.startTime) &&
               Objects.equals(endTime, other.endTime) &&
               Objects.equals(activityDurations, other.activityDurations) &&
               Objects.equals(reservationsCreated, other.reservationsCreated) &&
               Objects.equals(reservationsAccepted, other.reservationsAccepted) &&
               Objects.equals(reservationsRejected, other.reservationsRejected) &&
               Objects.equals(reservationsTimedOut, other.reservationsTimedOut) &&
               Objects.equals(reservationsCanceled, other.reservationsCanceled) &&
               Objects.equals(reservationsRescinded, other.reservationsRescinded) &&
               Objects.equals(workspaceSid, other.workspaceSid) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            startTime,
                            endTime,
                            activityDurations,
                            reservationsCreated,
                            reservationsAccepted,
                            reservationsRejected,
                            reservationsTimedOut,
                            reservationsCanceled,
                            reservationsRescinded,
                            workspaceSid,
                            url);
    }
}