/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace.workflow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class WorkflowRealTimeStatistics extends Resource {
    private static final long serialVersionUID = 195171007786684L;

    /**
     * Create a WorkflowRealTimeStatisticsFetcher to execute fetch.
     *
     * @param pathWorkspaceSid The SID of the Workspace with the Workflow to fetch
     * @param pathWorkflowSid Returns the list of Tasks that are being controlled
     *                        by the Workflow with the specified SID value
     * @return WorkflowRealTimeStatisticsFetcher capable of executing the fetch
     */
    public static WorkflowRealTimeStatisticsFetcher fetcher(final String pathWorkspaceSid,
                                                            final String pathWorkflowSid) {
        return new WorkflowRealTimeStatisticsFetcher(pathWorkspaceSid, pathWorkflowSid);
    }

    /**
     * Converts a JSON String into a WorkflowRealTimeStatistics object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return WorkflowRealTimeStatistics object represented by the provided JSON
     */
    public static WorkflowRealTimeStatistics fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, WorkflowRealTimeStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a WorkflowRealTimeStatistics object using
     * the provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return WorkflowRealTimeStatistics object represented by the provided JSON
     */
    public static WorkflowRealTimeStatistics fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, WorkflowRealTimeStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final Integer longestTaskWaitingAge;
    private final String longestTaskWaitingSid;
    private final Map<String, Object> tasksByPriority;
    private final Map<String, Object> tasksByStatus;
    private final Integer totalTasks;
    private final String workflowSid;
    private final String workspaceSid;
    private final URI url;

    @JsonCreator
    private WorkflowRealTimeStatistics(@JsonProperty("account_sid")
                                       final String accountSid,
                                       @JsonProperty("longest_task_waiting_age")
                                       final Integer longestTaskWaitingAge,
                                       @JsonProperty("longest_task_waiting_sid")
                                       final String longestTaskWaitingSid,
                                       @JsonProperty("tasks_by_priority")
                                       final Map<String, Object> tasksByPriority,
                                       @JsonProperty("tasks_by_status")
                                       final Map<String, Object> tasksByStatus,
                                       @JsonProperty("total_tasks")
                                       final Integer totalTasks,
                                       @JsonProperty("workflow_sid")
                                       final String workflowSid,
                                       @JsonProperty("workspace_sid")
                                       final String workspaceSid,
                                       @JsonProperty("url")
                                       final URI url) {
        this.accountSid = accountSid;
        this.longestTaskWaitingAge = longestTaskWaitingAge;
        this.longestTaskWaitingSid = longestTaskWaitingSid;
        this.tasksByPriority = tasksByPriority;
        this.tasksByStatus = tasksByStatus;
        this.totalTasks = totalTasks;
        this.workflowSid = workflowSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The age of the longest waiting Task.
     *
     * @return The age of the longest waiting Task
     */
    public final Integer getLongestTaskWaitingAge() {
        return this.longestTaskWaitingAge;
    }

    /**
     * Returns The SID of the longest waiting Task.
     *
     * @return The SID of the longest waiting Task
     */
    public final String getLongestTaskWaitingSid() {
        return this.longestTaskWaitingSid;
    }

    /**
     * Returns The number of Tasks by priority.
     *
     * @return The number of Tasks by priority
     */
    public final Map<String, Object> getTasksByPriority() {
        return this.tasksByPriority;
    }

    /**
     * Returns The number of Tasks by their current status.
     *
     * @return The number of Tasks by their current status
     */
    public final Map<String, Object> getTasksByStatus() {
        return this.tasksByStatus;
    }

    /**
     * Returns The total number of Tasks.
     *
     * @return The total number of Tasks
     */
    public final Integer getTotalTasks() {
        return this.totalTasks;
    }

    /**
     * Returns Returns the list of Tasks that are being controlled by the Workflow
     * with the specified SID value.
     *
     * @return Returns the list of Tasks that are being controlled by the Workflow
     *         with the specified SID value
     */
    public final String getWorkflowSid() {
        return this.workflowSid;
    }

    /**
     * Returns The SID of the Workspace that contains the Workflow..
     *
     * @return The SID of the Workspace that contains the Workflow.
     */
    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    /**
     * Returns The absolute URL of the Workflow statistics resource.
     *
     * @return The absolute URL of the Workflow statistics resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        WorkflowRealTimeStatistics other = (WorkflowRealTimeStatistics) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(longestTaskWaitingAge, other.longestTaskWaitingAge) &&
               Objects.equals(longestTaskWaitingSid, other.longestTaskWaitingSid) &&
               Objects.equals(tasksByPriority, other.tasksByPriority) &&
               Objects.equals(tasksByStatus, other.tasksByStatus) &&
               Objects.equals(totalTasks, other.totalTasks) &&
               Objects.equals(workflowSid, other.workflowSid) &&
               Objects.equals(workspaceSid, other.workspaceSid) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            longestTaskWaitingAge,
                            longestTaskWaitingSid,
                            tasksByPriority,
                            tasksByStatus,
                            totalTasks,
                            workflowSid,
                            workspaceSid,
                            url);
    }
}