/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.taskrouter.v1.workspace.workflow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class WorkflowStatistics extends Resource {
    private static final long serialVersionUID = 71533106021042L;

    /**
     * Create a WorkflowStatisticsFetcher to execute fetch.
     *
     * @param pathWorkspaceSid The SID of the Workspace with the Workflow to fetch
     * @param pathWorkflowSid Returns the list of Tasks that are being controlled
     *                        by the Workflow with the specified SID value
     * @return WorkflowStatisticsFetcher capable of executing the fetch
     */
    public static WorkflowStatisticsFetcher fetcher(final String pathWorkspaceSid,
                                                    final String pathWorkflowSid) {
        return new WorkflowStatisticsFetcher(pathWorkspaceSid, pathWorkflowSid);
    }

    /**
     * Converts a JSON String into a WorkflowStatistics object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return WorkflowStatistics object represented by the provided JSON
     */
    public static WorkflowStatistics fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, WorkflowStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a WorkflowStatistics object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return WorkflowStatistics object represented by the provided JSON
     */
    public static WorkflowStatistics fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, WorkflowStatistics.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final Map<String, Object> cumulative;
    private final Map<String, Object> realtime;
    private final String workflowSid;
    private final String workspaceSid;
    private final URI url;

    @JsonCreator
    private WorkflowStatistics(@JsonProperty("account_sid")
                               final String accountSid,
                               @JsonProperty("cumulative")
                               final Map<String, Object> cumulative,
                               @JsonProperty("realtime")
                               final Map<String, Object> realtime,
                               @JsonProperty("workflow_sid")
                               final String workflowSid,
                               @JsonProperty("workspace_sid")
                               final String workspaceSid,
                               @JsonProperty("url")
                               final URI url) {
        this.accountSid = accountSid;
        this.cumulative = cumulative;
        this.realtime = realtime;
        this.workflowSid = workflowSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns An object that contains the cumulative statistics for the Workflow.
     *
     * @return An object that contains the cumulative statistics for the Workflow
     */
    public final Map<String, Object> getCumulative() {
        return this.cumulative;
    }

    /**
     * Returns An object that contains the real-time statistics for the Workflow.
     *
     * @return An object that contains the real-time statistics for the Workflow
     */
    public final Map<String, Object> getRealtime() {
        return this.realtime;
    }

    /**
     * Returns Returns the list of Tasks that are being controlled by the Workflow
     * with the specified SID value.
     *
     * @return Returns the list of Tasks that are being controlled by the Workflow
     *         with the specified SID value
     */
    public final String getWorkflowSid() {
        return this.workflowSid;
    }

    /**
     * Returns The SID of the Workspace that contains the Workflow.
     *
     * @return The SID of the Workspace that contains the Workflow
     */
    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    /**
     * Returns The absolute URL of the Workflow statistics resource.
     *
     * @return The absolute URL of the Workflow statistics resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        WorkflowStatistics other = (WorkflowStatistics) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(cumulative, other.cumulative) &&
               Objects.equals(realtime, other.realtime) &&
               Objects.equals(workflowSid, other.workflowSid) &&
               Objects.equals(workspaceSid, other.workspaceSid) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            cumulative,
                            realtime,
                            workflowSid,
                            workspaceSid,
                            url);
    }
}