/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trunking.v1.trunk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Recording extends Resource {
    private static final long serialVersionUID = 256465659878704L;

    public enum RecordingMode {
        DO_NOT_RECORD("do-not-record"),
        RECORD_FROM_RINGING("record-from-ringing"),
        RECORD_FROM_ANSWER("record-from-answer"),
        RECORD_FROM_RINGING_DUAL("record-from-ringing-dual"),
        RECORD_FROM_ANSWER_DUAL("record-from-answer-dual");

        private final String value;

        private RecordingMode(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a RecordingMode from a string.
         * @param value string value
         * @return generated RecordingMode
         */
        @JsonCreator
        public static RecordingMode forValue(final String value) {
            return Promoter.enumFromString(value, RecordingMode.values());
        }
    }

    public enum RecordingTrim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private RecordingTrim(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a RecordingTrim from a string.
         * @param value string value
         * @return generated RecordingTrim
         */
        @JsonCreator
        public static RecordingTrim forValue(final String value) {
            return Promoter.enumFromString(value, RecordingTrim.values());
        }
    }

    /**
     * Create a RecordingFetcher to execute fetch.
     *
     * @param pathTrunkSid The SID of the Trunk from which to fetch the recording
     *                     settings.
     * @return RecordingFetcher capable of executing the fetch
     */
    public static RecordingFetcher fetcher(final String pathTrunkSid) {
        return new RecordingFetcher(pathTrunkSid);
    }

    /**
     * Create a RecordingUpdater to execute update.
     *
     * @param pathTrunkSid The SID of the Trunk.
     * @return RecordingUpdater capable of executing the update
     */
    public static RecordingUpdater updater(final String pathTrunkSid) {
        return new RecordingUpdater(pathTrunkSid);
    }

    /**
     * Converts a JSON String into a Recording object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Recording object represented by the provided JSON
     */
    public static Recording fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Recording.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Recording object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Recording object represented by the provided JSON
     */
    public static Recording fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Recording.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final Recording.RecordingMode mode;
    private final Recording.RecordingTrim trim;

    @JsonCreator
    private Recording(@JsonProperty("mode")
                      final Recording.RecordingMode mode,
                      @JsonProperty("trim")
                      final Recording.RecordingTrim trim) {
        this.mode = mode;
        this.trim = trim;
    }

    /**
     * Returns The recording mode for the trunk..
     *
     * @return The recording mode for the trunk.
     */
    public final Recording.RecordingMode getMode() {
        return this.mode;
    }

    /**
     * Returns The recording trim setting for the trunk..
     *
     * @return The recording trim setting for the trunk.
     */
    public final Recording.RecordingTrim getTrim() {
        return this.trim;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Recording other = (Recording) o;

        return Objects.equals(mode, other.mode) &&
               Objects.equals(trim, other.trim);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mode,
                            trim);
    }
}