/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trusthub.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class TrustProductsCreator extends Creator<TrustProducts> {
    private final String friendlyName;
    private final String email;
    private final String policySid;
    private URI statusCallback;

    /**
     * Construct a new TrustProductsCreator.
     *
     * @param friendlyName The string that you assigned to describe the resource
     * @param email The email address
     * @param policySid The unique string of a policy.
     */
    public TrustProductsCreator(final String friendlyName,
                                final String email,
                                final String policySid) {
        this.friendlyName = friendlyName;
        this.email = email;
        this.policySid = policySid;
    }

    /**
     * The URL we call to inform your application of status changes..
     *
     * @param statusCallback The URL we call to inform your application of status
     *                       changes.
     * @return this
     */
    public TrustProductsCreator setStatusCallback(final URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    /**
     * The URL we call to inform your application of status changes..
     *
     * @param statusCallback The URL we call to inform your application of status
     *                       changes.
     * @return this
     */
    public TrustProductsCreator setStatusCallback(final String statusCallback) {
        return setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created TrustProducts
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public TrustProducts create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TRUSTHUB.toString(),
            "/v1/TrustProducts"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("TrustProducts creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return TrustProducts.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (email != null) {
            request.addPostParam("Email", email);
        }

        if (policySid != null) {
            request.addPostParam("PolicySid", policySid);
        }

        if (statusCallback != null) {
            request.addPostParam("StatusCallback", statusCallback.toString());
        }
    }
}