/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trusthub.v1.trustproducts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class TrustProductsChannelEndpointAssignment extends Resource {
    private static final long serialVersionUID = 50827114270251L;

    /**
     * Create a TrustProductsChannelEndpointAssignmentCreator to execute create.
     *
     * @param pathTrustProductSid The unique string that identifies the resource.
     * @param channelEndpointType The type of channel endpoint
     * @param channelEndpointSid The sid of an channel endpoint
     * @return TrustProductsChannelEndpointAssignmentCreator capable of executing
     *         the create
     */
    public static TrustProductsChannelEndpointAssignmentCreator creator(final String pathTrustProductSid,
                                                                        final String channelEndpointType,
                                                                        final String channelEndpointSid) {
        return new TrustProductsChannelEndpointAssignmentCreator(pathTrustProductSid, channelEndpointType, channelEndpointSid);
    }

    /**
     * Create a TrustProductsChannelEndpointAssignmentReader to execute read.
     *
     * @param pathTrustProductSid The unique string that identifies the resource.
     * @return TrustProductsChannelEndpointAssignmentReader capable of executing
     *         the read
     */
    public static TrustProductsChannelEndpointAssignmentReader reader(final String pathTrustProductSid) {
        return new TrustProductsChannelEndpointAssignmentReader(pathTrustProductSid);
    }

    /**
     * Create a TrustProductsChannelEndpointAssignmentFetcher to execute fetch.
     *
     * @param pathTrustProductSid The unique string that identifies the resource.
     * @param pathSid The unique string that identifies the resource
     * @return TrustProductsChannelEndpointAssignmentFetcher capable of executing
     *         the fetch
     */
    public static TrustProductsChannelEndpointAssignmentFetcher fetcher(final String pathTrustProductSid,
                                                                        final String pathSid) {
        return new TrustProductsChannelEndpointAssignmentFetcher(pathTrustProductSid, pathSid);
    }

    /**
     * Create a TrustProductsChannelEndpointAssignmentDeleter to execute delete.
     *
     * @param pathTrustProductSid The unique string that identifies the resource.
     * @param pathSid The unique string that identifies the resource
     * @return TrustProductsChannelEndpointAssignmentDeleter capable of executing
     *         the delete
     */
    public static TrustProductsChannelEndpointAssignmentDeleter deleter(final String pathTrustProductSid,
                                                                        final String pathSid) {
        return new TrustProductsChannelEndpointAssignmentDeleter(pathTrustProductSid, pathSid);
    }

    /**
     * Converts a JSON String into a TrustProductsChannelEndpointAssignment object
     * using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return TrustProductsChannelEndpointAssignment object represented by the
     *         provided JSON
     */
    public static TrustProductsChannelEndpointAssignment fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, TrustProductsChannelEndpointAssignment.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a TrustProductsChannelEndpointAssignment
     * object using the provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return TrustProductsChannelEndpointAssignment object represented by the
     *         provided JSON
     */
    public static TrustProductsChannelEndpointAssignment fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, TrustProductsChannelEndpointAssignment.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String trustProductSid;
    private final String accountSid;
    private final String channelEndpointType;
    private final String channelEndpointSid;
    private final ZonedDateTime dateCreated;
    private final URI url;

    @JsonCreator
    private TrustProductsChannelEndpointAssignment(@JsonProperty("sid")
                                                   final String sid,
                                                   @JsonProperty("trust_product_sid")
                                                   final String trustProductSid,
                                                   @JsonProperty("account_sid")
                                                   final String accountSid,
                                                   @JsonProperty("channel_endpoint_type")
                                                   final String channelEndpointType,
                                                   @JsonProperty("channel_endpoint_sid")
                                                   final String channelEndpointSid,
                                                   @JsonProperty("date_created")
                                                   final String dateCreated,
                                                   @JsonProperty("url")
                                                   final URI url) {
        this.sid = sid;
        this.trustProductSid = trustProductSid;
        this.accountSid = accountSid;
        this.channelEndpointType = channelEndpointType;
        this.channelEndpointSid = channelEndpointSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The unique string that identifies the CustomerProfile resource..
     *
     * @return The unique string that identifies the CustomerProfile resource.
     */
    public final String getTrustProductSid() {
        return this.trustProductSid;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The type of channel endpoint.
     *
     * @return The type of channel endpoint
     */
    public final String getChannelEndpointType() {
        return this.channelEndpointType;
    }

    /**
     * Returns The sid of an channel endpoint.
     *
     * @return The sid of an channel endpoint
     */
    public final String getChannelEndpointSid() {
        return this.channelEndpointSid;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The absolute URL of the Identity resource.
     *
     * @return The absolute URL of the Identity resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TrustProductsChannelEndpointAssignment other = (TrustProductsChannelEndpointAssignment) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(trustProductSid, other.trustProductSid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(channelEndpointType, other.channelEndpointType) &&
               Objects.equals(channelEndpointSid, other.channelEndpointSid) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            trustProductSid,
                            accountSid,
                            channelEndpointType,
                            channelEndpointSid,
                            dateCreated,
                            url);
    }
}