/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trusthub.v1.trustproducts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class TrustProductsEvaluations extends Resource {
    private static final long serialVersionUID = 60147493077422L;

    public enum Status {
        COMPLIANT("compliant"),
        NONCOMPLIANT("noncompliant");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    /**
     * Create a TrustProductsEvaluationsCreator to execute create.
     *
     * @param pathTrustProductSid The unique string that identifies the resource
     * @param policySid The unique string of a policy
     * @return TrustProductsEvaluationsCreator capable of executing the create
     */
    public static TrustProductsEvaluationsCreator creator(final String pathTrustProductSid,
                                                          final String policySid) {
        return new TrustProductsEvaluationsCreator(pathTrustProductSid, policySid);
    }

    /**
     * Create a TrustProductsEvaluationsReader to execute read.
     *
     * @param pathTrustProductSid The unique string that identifies the resource
     * @return TrustProductsEvaluationsReader capable of executing the read
     */
    public static TrustProductsEvaluationsReader reader(final String pathTrustProductSid) {
        return new TrustProductsEvaluationsReader(pathTrustProductSid);
    }

    /**
     * Create a TrustProductsEvaluationsFetcher to execute fetch.
     *
     * @param pathTrustProductSid The unique string that identifies the resource
     * @param pathSid The unique string that identifies the Evaluation resource
     * @return TrustProductsEvaluationsFetcher capable of executing the fetch
     */
    public static TrustProductsEvaluationsFetcher fetcher(final String pathTrustProductSid,
                                                          final String pathSid) {
        return new TrustProductsEvaluationsFetcher(pathTrustProductSid, pathSid);
    }

    /**
     * Converts a JSON String into a TrustProductsEvaluations object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return TrustProductsEvaluations object represented by the provided JSON
     */
    public static TrustProductsEvaluations fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, TrustProductsEvaluations.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a TrustProductsEvaluations object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return TrustProductsEvaluations object represented by the provided JSON
     */
    public static TrustProductsEvaluations fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, TrustProductsEvaluations.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String policySid;
    private final String trustProductSid;
    private final TrustProductsEvaluations.Status status;
    private final List<Map<String, Object>> results;
    private final ZonedDateTime dateCreated;
    private final URI url;

    @JsonCreator
    private TrustProductsEvaluations(@JsonProperty("sid")
                                     final String sid,
                                     @JsonProperty("account_sid")
                                     final String accountSid,
                                     @JsonProperty("policy_sid")
                                     final String policySid,
                                     @JsonProperty("trust_product_sid")
                                     final String trustProductSid,
                                     @JsonProperty("status")
                                     final TrustProductsEvaluations.Status status,
                                     @JsonProperty("results")
                                     final List<Map<String, Object>> results,
                                     @JsonProperty("date_created")
                                     final String dateCreated,
                                     @JsonProperty("url")
                                     final URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.policySid = policySid;
        this.trustProductSid = trustProductSid;
        this.status = status;
        this.results = results;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the Evaluation resource.
     *
     * @return The unique string that identifies the Evaluation resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The unique string of a policy.
     *
     * @return The unique string of a policy
     */
    public final String getPolicySid() {
        return this.policySid;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getTrustProductSid() {
        return this.trustProductSid;
    }

    /**
     * Returns The compliance status of the Evaluation resource.
     *
     * @return The compliance status of the Evaluation resource
     */
    public final TrustProductsEvaluations.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The results of the Evaluation resource.
     *
     * @return The results of the Evaluation resource
     */
    public final List<Map<String, Object>> getResults() {
        return this.results;
    }

    /**
     * Returns The date_created.
     *
     * @return The date_created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TrustProductsEvaluations other = (TrustProductsEvaluations) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(policySid, other.policySid) &&
               Objects.equals(trustProductSid, other.trustProductSid) &&
               Objects.equals(status, other.status) &&
               Objects.equals(results, other.results) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            policySid,
                            trustProductSid,
                            status,
                            results,
                            dateCreated,
                            url);
    }
}