/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class VerificationAttempt extends Resource {
    private static final long serialVersionUID = 76976954570700L;

    public enum Channels {
        SMS("sms"),
        CALL("call"),
        EMAIL("email"),
        WHATSAPP("whatsapp");

        private final String value;

        private Channels(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Channels from a string.
         * @param value string value
         * @return generated Channels
         */
        @JsonCreator
        public static Channels forValue(final String value) {
            return Promoter.enumFromString(value, Channels.values());
        }
    }

    public enum CallStatus {
        QUEUED("queued"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        BUSY("busy"),
        FAILED("failed"),
        NO_ANSWER("no-answer"),
        RINGING("ringing"),
        CANCELED("canceled");

        private final String value;

        private CallStatus(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a CallStatus from a string.
         * @param value string value
         * @return generated CallStatus
         */
        @JsonCreator
        public static CallStatus forValue(final String value) {
            return Promoter.enumFromString(value, CallStatus.values());
        }
    }

    public enum MessageStatus {
        QUEUED("queued"),
        SENDING("sending"),
        SENT("sent"),
        FAILED("failed"),
        DELIVERED("delivered"),
        UNDELIVERED("undelivered"),
        RECEIVING("receiving"),
        RECEIVED("received"),
        ACCEPTED("accepted"),
        SCHEDULED("scheduled"),
        READ("read"),
        PARTIALLY_DELIVERED("partially_delivered"),
        CANCELED("canceled");

        private final String value;

        private MessageStatus(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a MessageStatus from a string.
         * @param value string value
         * @return generated MessageStatus
         */
        @JsonCreator
        public static MessageStatus forValue(final String value) {
            return Promoter.enumFromString(value, MessageStatus.values());
        }
    }

    public enum ConversionStatus {
        CONVERTED("converted"),
        UNCONVERTED("unconverted");

        private final String value;

        private ConversionStatus(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a ConversionStatus from a string.
         * @param value string value
         * @return generated ConversionStatus
         */
        @JsonCreator
        public static ConversionStatus forValue(final String value) {
            return Promoter.enumFromString(value, ConversionStatus.values());
        }
    }

    public enum AttemptStatus {
        CONFIRMED("confirmed"),
        UNCONFIRMED("unconfirmed"),
        EXPIRED("expired");

        private final String value;

        private AttemptStatus(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a AttemptStatus from a string.
         * @param value string value
         * @return generated AttemptStatus
         */
        @JsonCreator
        public static AttemptStatus forValue(final String value) {
            return Promoter.enumFromString(value, AttemptStatus.values());
        }
    }

    /**
     * Create a VerificationAttemptReader to execute read.
     *
     * @return VerificationAttemptReader capable of executing the read
     */
    public static VerificationAttemptReader reader() {
        return new VerificationAttemptReader();
    }

    /**
     * Create a VerificationAttemptFetcher to execute fetch.
     *
     * @param pathSid Verification Attempt Sid.
     * @return VerificationAttemptFetcher capable of executing the fetch
     */
    public static VerificationAttemptFetcher fetcher(final String pathSid) {
        return new VerificationAttemptFetcher(pathSid);
    }

    /**
     * Converts a JSON String into a VerificationAttempt object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return VerificationAttempt object represented by the provided JSON
     */
    public static VerificationAttempt fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, VerificationAttempt.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a VerificationAttempt object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return VerificationAttempt object represented by the provided JSON
     */
    public static VerificationAttempt fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, VerificationAttempt.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String verificationSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final VerificationAttempt.ConversionStatus conversionStatus;
    private final VerificationAttempt.Channels channel;
    private final Map<String, Object> price;
    private final Map<String, Object> channelData;
    private final URI url;

    @JsonCreator
    private VerificationAttempt(@JsonProperty("sid")
                                final String sid,
                                @JsonProperty("account_sid")
                                final String accountSid,
                                @JsonProperty("service_sid")
                                final String serviceSid,
                                @JsonProperty("verification_sid")
                                final String verificationSid,
                                @JsonProperty("date_created")
                                final String dateCreated,
                                @JsonProperty("date_updated")
                                final String dateUpdated,
                                @JsonProperty("conversion_status")
                                final VerificationAttempt.ConversionStatus conversionStatus,
                                @JsonProperty("channel")
                                final VerificationAttempt.Channels channel,
                                @JsonProperty("price")
                                final Map<String, Object> price,
                                @JsonProperty("channel_data")
                                final Map<String, Object> channelData,
                                @JsonProperty("url")
                                final URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.verificationSid = verificationSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.conversionStatus = conversionStatus;
        this.channel = channel;
        this.price = price;
        this.channelData = channelData;
        this.url = url;
    }

    /**
     * Returns The SID that uniquely identifies the verification attempt..
     *
     * @return The SID that uniquely identifies the verification attempt.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the Account that created the verification..
     *
     * @return The SID of the Account that created the verification.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the verify service that generated this attempt..
     *
     * @return The SID of the verify service that generated this attempt.
     */
    public final String getServiceSid() {
        return this.serviceSid;
    }

    /**
     * Returns The SID of the verification that generated this attempt..
     *
     * @return The SID of the verification that generated this attempt.
     */
    public final String getVerificationSid() {
        return this.verificationSid;
    }

    /**
     * Returns The date this Attempt was created.
     *
     * @return The date this Attempt was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The date this Attempt was updated.
     *
     * @return The date this Attempt was updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns Status of the conversion for the verification..
     *
     * @return Status of the conversion for the verification.
     */
    public final VerificationAttempt.ConversionStatus getConversionStatus() {
        return this.conversionStatus;
    }

    /**
     * Returns Communication channel used for the attempt..
     *
     * @return Communication channel used for the attempt.
     */
    public final VerificationAttempt.Channels getChannel() {
        return this.channel;
    }

    /**
     * Returns An object containing the charge for this verification attempt..
     *
     * @return An object containing the charge for this verification attempt.
     */
    public final Map<String, Object> getPrice() {
        return this.price;
    }

    /**
     * Returns An object containing the channel specific information for an
     * attempt..
     *
     * @return An object containing the channel specific information for an attempt.
     */
    public final Map<String, Object> getChannelData() {
        return this.channelData;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        VerificationAttempt other = (VerificationAttempt) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(serviceSid, other.serviceSid) &&
               Objects.equals(verificationSid, other.verificationSid) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(conversionStatus, other.conversionStatus) &&
               Objects.equals(channel, other.channel) &&
               Objects.equals(price, other.price) &&
               Objects.equals(channelData, other.channelData) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            accountSid,
                            serviceSid,
                            verificationSid,
                            dateCreated,
                            dateUpdated,
                            conversionStatus,
                            channel,
                            price,
                            channelData,
                            url);
    }
}