/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class VerificationAttemptsSummary extends Resource {
    private static final long serialVersionUID = 83219836493096L;

    public enum Channels {
        SMS("sms"),
        CALL("call"),
        EMAIL("email"),
        WHATSAPP("whatsapp");

        private final String value;

        private Channels(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Channels from a string.
         * @param value string value
         * @return generated Channels
         */
        @JsonCreator
        public static Channels forValue(final String value) {
            return Promoter.enumFromString(value, Channels.values());
        }
    }

    /**
     * Create a VerificationAttemptsSummaryFetcher to execute fetch.
     *
     * @return VerificationAttemptsSummaryFetcher capable of executing the fetch
     */
    public static VerificationAttemptsSummaryFetcher fetcher() {
        return new VerificationAttemptsSummaryFetcher();
    }

    /**
     * Converts a JSON String into a VerificationAttemptsSummary object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return VerificationAttemptsSummary object represented by the provided JSON
     */
    public static VerificationAttemptsSummary fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, VerificationAttemptsSummary.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a VerificationAttemptsSummary object using
     * the provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return VerificationAttemptsSummary object represented by the provided JSON
     */
    public static VerificationAttemptsSummary fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, VerificationAttemptsSummary.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final Integer totalAttempts;
    private final Integer totalConverted;
    private final Integer totalUnconverted;
    private final BigDecimal conversionRatePercentage;
    private final URI url;

    @JsonCreator
    private VerificationAttemptsSummary(@JsonProperty("total_attempts")
                                        final Integer totalAttempts,
                                        @JsonProperty("total_converted")
                                        final Integer totalConverted,
                                        @JsonProperty("total_unconverted")
                                        final Integer totalUnconverted,
                                        @JsonProperty("conversion_rate_percentage")
                                        final BigDecimal conversionRatePercentage,
                                        @JsonProperty("url")
                                        final URI url) {
        this.totalAttempts = totalAttempts;
        this.totalConverted = totalConverted;
        this.totalUnconverted = totalUnconverted;
        this.conversionRatePercentage = conversionRatePercentage;
        this.url = url;
    }

    /**
     * Returns Total of attempts made..
     *
     * @return Total of attempts made.
     */
    public final Integer getTotalAttempts() {
        return this.totalAttempts;
    }

    /**
     * Returns Total of attempts confirmed by the end user..
     *
     * @return Total of attempts confirmed by the end user.
     */
    public final Integer getTotalConverted() {
        return this.totalConverted;
    }

    /**
     * Returns Total of attempts made that were not confirmed by the end user..
     *
     * @return Total of attempts made that were not confirmed by the end user.
     */
    public final Integer getTotalUnconverted() {
        return this.totalUnconverted;
    }

    /**
     * Returns Percentage of the confirmed messages over the total..
     *
     * @return Percentage of the confirmed messages over the total.
     */
    public final BigDecimal getConversionRatePercentage() {
        return this.conversionRatePercentage;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        VerificationAttemptsSummary other = (VerificationAttemptsSummary) o;

        return Objects.equals(totalAttempts, other.totalAttempts) &&
               Objects.equals(totalConverted, other.totalConverted) &&
               Objects.equals(totalUnconverted, other.totalUnconverted) &&
               Objects.equals(conversionRatePercentage, other.conversionRatePercentage) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(totalAttempts,
                            totalConverted,
                            totalUnconverted,
                            conversionRatePercentage,
                            url);
    }
}