/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2;

import com.twilio.base.Fetcher;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.time.ZonedDateTime;

public class VerificationAttemptsSummaryFetcher extends Fetcher<VerificationAttemptsSummary> {
    private String verifyServiceSid;
    private ZonedDateTime dateCreatedAfter;
    private ZonedDateTime dateCreatedBefore;
    private String country;
    private VerificationAttemptsSummary.Channels channel;
    private String destinationPrefix;

    /**
     * Filter used to consider only Verification Attempts of the given verify
     * service on the summary aggregation..
     *
     * @param verifyServiceSid Filter the verification attempts considered on the
     *                         summary by verify service.
     * @return this
     */
    public VerificationAttemptsSummaryFetcher setVerifyServiceSid(final String verifyServiceSid) {
        this.verifyServiceSid = verifyServiceSid;
        return this;
    }

    /**
     * Datetime filter used to consider only Verification Attempts created after
     * this datetime on the summary aggregation. Given as GMT in RFC 2822 format..
     *
     * @param dateCreatedAfter Consider verification attempts create after this
     *                         date on the summary.
     * @return this
     */
    public VerificationAttemptsSummaryFetcher setDateCreatedAfter(final ZonedDateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    /**
     * Datetime filter used to consider only Verification Attempts created before
     * this datetime on the summary aggregation. Given as GMT in RFC 2822 format..
     *
     * @param dateCreatedBefore Consider verification attempts created before this
     *                          date on the summary.
     * @return this
     */
    public VerificationAttemptsSummaryFetcher setDateCreatedBefore(final ZonedDateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    /**
     * Filter used to consider only Verification Attempts sent to the specified
     * destination country on the summary aggregation..
     *
     * @param country Filter verification attempts considered on the summary by
     *                destination country.
     * @return this
     */
    public VerificationAttemptsSummaryFetcher setCountry(final String country) {
        this.country = country;
        return this;
    }

    /**
     * Filter Verification Attempts considered on the summary aggregation by
     * communication channel. Valid values are `SMS` and `CALL`.
     *
     * @param channel Filter verification attempts considered on the summary by
     *                communication channel.
     * @return this
     */
    public VerificationAttemptsSummaryFetcher setChannel(final VerificationAttemptsSummary.Channels channel) {
        this.channel = channel;
        return this;
    }

    /**
     * Filter the Verification Attempts considered on the summary aggregation by
     * Destination prefix. It is the prefix of a phone number in E.164 format..
     *
     * @param destinationPrefix Filters the attempts considered on the summary by
     *                          destination prefix.
     * @return this
     */
    public VerificationAttemptsSummaryFetcher setDestinationPrefix(final String destinationPrefix) {
        this.destinationPrefix = destinationPrefix;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched VerificationAttemptsSummary
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public VerificationAttemptsSummary fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.VERIFY.toString(),
            "/v2/Attempts/Summary"
        );

        addQueryParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("VerificationAttemptsSummary fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return VerificationAttemptsSummary.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (verifyServiceSid != null) {
            request.addQueryParam("VerifyServiceSid", verifyServiceSid);
        }

        if (dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", dateCreatedAfter.toInstant().toString());
        }

        if (dateCreatedBefore != null) {
            request.addQueryParam("DateCreatedBefore", dateCreatedBefore.toInstant().toString());
        }

        if (country != null) {
            request.addQueryParam("Country", country);
        }

        if (channel != null) {
            request.addQueryParam("Channel", channel.toString());
        }

        if (destinationPrefix != null) {
            request.addQueryParam("DestinationPrefix", destinationPrefix);
        }
    }
}