/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2.service;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class MessagingConfigurationFetcher extends Fetcher<MessagingConfiguration> {
    private final String pathServiceSid;
    private final String pathCountry;

    /**
     * Construct a new MessagingConfigurationFetcher.
     *
     * @param pathServiceSid The SID of the Service that the resource is associated
     *                       with
     * @param pathCountry The ISO-3166-1 country code of the country or `all`.
     */
    public MessagingConfigurationFetcher(final String pathServiceSid,
                                         final String pathCountry) {
        this.pathServiceSid = pathServiceSid;
        this.pathCountry = pathCountry;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched MessagingConfiguration
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public MessagingConfiguration fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.VERIFY.toString(),
            "/v2/Services/" + this.pathServiceSid + "/MessagingConfigurations/" + this.pathCountry + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("MessagingConfiguration fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return MessagingConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }
}