/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.verify.v2.service;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.List;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class WebhookUpdater extends Updater<Webhook> {
    private final String pathServiceSid;
    private final String pathSid;
    private String friendlyName;
    private List<String> eventTypes;
    private String webhookUrl;
    private Webhook.Status status;
    private Webhook.Version version;

    /**
     * Construct a new WebhookUpdater.
     *
     * @param pathServiceSid Service Sid.
     * @param pathSid The unique string that identifies the resource
     */
    public WebhookUpdater(final String pathServiceSid,
                          final String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    /**
     * The string that you assigned to describe the webhook. **This value should not
     * contain PII.**.
     *
     * @param friendlyName The string that you assigned to describe the webhook
     * @return this
     */
    public WebhookUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The array of events that this Webhook is subscribed to. Possible event types:
     * `*, factor.deleted, factor.created, factor.verified, challenge.approved,
     * challenge.denied`.
     *
     * @param eventTypes The array of events that this Webhook is subscribed to.
     * @return this
     */
    public WebhookUpdater setEventTypes(final List<String> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    /**
     * The array of events that this Webhook is subscribed to. Possible event types:
     * `*, factor.deleted, factor.created, factor.verified, challenge.approved,
     * challenge.denied`.
     *
     * @param eventTypes The array of events that this Webhook is subscribed to.
     * @return this
     */
    public WebhookUpdater setEventTypes(final String eventTypes) {
        return setEventTypes(Promoter.listOfOne(eventTypes));
    }

    /**
     * The URL associated with this Webhook..
     *
     * @param webhookUrl The URL associated with this Webhook.
     * @return this
     */
    public WebhookUpdater setWebhookUrl(final String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    /**
     * The webhook status. Default value is `enabled`. One of: `enabled` or
     * `disabled`.
     *
     * @param status The webhook status
     * @return this
     */
    public WebhookUpdater setStatus(final Webhook.Status status) {
        this.status = status;
        return this;
    }

    /**
     * The webhook version. Default value is `v2` which includes all the latest
     * fields. Version `v1` is legacy and may be removed in the future..
     *
     * @param version The webhook version
     * @return this
     */
    public WebhookUpdater setVersion(final Webhook.Version version) {
        this.version = version;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Webhook
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Webhook update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.VERIFY.toString(),
            "/v2/Services/" + this.pathServiceSid + "/Webhooks/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Webhook update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (eventTypes != null) {
            for (String prop : eventTypes) {
                request.addPostParam("EventTypes", prop);
            }
        }

        if (webhookUrl != null) {
            request.addPostParam("WebhookUrl", webhookUrl);
        }

        if (status != null) {
            request.addPostParam("Status", status.toString());
        }

        if (version != null) {
            request.addPostParam("Version", version.toString());
        }
    }
}